% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalwarp_grid.R
\name{gdalwarp_grid}
\alias{gdalwarp_grid}
\title{Warp a raster file aligning it on the grid of another file}
\usage{
gdalwarp_grid(srcfiles, dstfiles, ref, of = NULL, r = NULL)
}
\arguments{
\item{srcfiles}{A vector of input file paths (managed by GDAL).}

\item{dstfiles}{A vector of input file paths.}

\item{ref}{Path of the raster taken as reference.}

\item{of}{The output format (use the short format name). Default is
the format of every input filename.}

\item{r}{Resampling_method ("near"|"bilinear"|"cubic"|"cubicspline"|
"lanczos"|"average"|"mode"|"max"|"min"|"med"|"q1"|"q3").}
}
\value{
NULL (the function is called for its side effects)
}
\description{
The function applies \code{gdalwarp} to build rasters with the
same projection, resolution and grid alignment of another raster.
If not specified, the output format of each file is the same of the
corresponding source file.
}
\note{
License: GPL 3.0
}
\examples{
\donttest{
# Define file names
ex_sel <- system.file(
  "extdata/out/S2A2A_20170703_022_Barbellino_BOA_10.tif",
  package = "sen2r"
)
ex_ref <- system.file(
  "extdata/out/S2A2A_20170703_022_Barbellino_SCL_10.tif",
  package = "sen2r"
)
ex_out <- tempfile(fileext = "_BOA_out.tif")

# Run function
sen2r:::gdalwarp_grid(ex_sel, ex_out, ref = ex_ref)

# Show output
oldpar <- par(mfrow = c(1,3), mar = rep(0,4))
image(stars::read_stars(ex_sel), rgb = 4:2, maxColorValue = 3500)
par(mar = rep(2/3,4)); image(stars::read_stars(ex_ref))
par(mar = rep(0,4)); image(stars::read_stars(ex_out), rgb = 4:2, maxColorValue = 3500)
par(oldpar)
}
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
