% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_cfa_layout.R
\name{set_cfa_layout}
\alias{set_cfa_layout}
\title{Configure the layout of factors of a CFA graph by semPaths}
\usage{
set_cfa_layout(
  semPaths_plot,
  indicator_order = NULL,
  indicator_factor = NULL,
  fcov_curve = 0.4,
  loading_position = 0.5,
  point_to = "down"
)
}
\arguments{
\item{semPaths_plot}{A \link[qgraph:qgraph]{qgraph::qgraph} object generated by
semPaths, or a similar qgraph object modified by other \link{semptools}
functions.}

\item{indicator_order}{A string vector of the indicators. The order
of the names is the order of the indicators in the graph, when they
are drawn on the bottom of the graph. The indicators should be
grouped by the factors on which they load on. For example, if x1,
x2, x4 load on f2, and x3, x5, x6 load on f1, then vector should be
either c("x1", "x2", "x4", "x3", "x5", "x6") or c("x3", "x5", "x6",
"x1", "x2", "x4"). Indicators within a group can be ordered in any
way. If it is a named vector, its names will be used for the
argument \code{indicator_factor}. If it is \code{NULL} (default),
\code{\link[=auto_indicator_order]{auto_indicator_order()}} will be called to determine the
indicator order automatically.}

\item{indicator_factor}{A string vector of the same length of the
indicator order, storing the name of the factor for which each of
the indicator in indicator_factor loads on. For example, if x1, x2,
x4 load on f2, and x3, x5, x6 load on f1, and indicator_order is
c("x3", "x5", "x6", "x1", "x2", "x4"), then indicator_factor should
be c("f2", "f2", "f2", "f1", "f1", "f1"). If \code{NULL}
(default) and \code{indicator_order} is a named vector (supplied
by users or generated by \code{\link[=auto_indicator_order]{auto_indicator_order()}}), then
it will be set to the names of \code{indicator_order}.}

\item{fcov_curve}{A number used to set the curvature of the
inter-factor covariances. Default is .4.}

\item{loading_position}{The positions of all factor loadings.
Default is .5, on the middle of the arrows. Larger the number,
closer the loadings to the indicators. Smaller the number, closer
the loadings to the factors.}

\item{point_to}{Can be "down", "left", "up", or "right". Specify the
direction that the factors "point" to the indicators. Default is
"down".}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} based on the original one, with various
aspects of the model modified.
}
\description{
Configure the layout of factors and adjust other
aspects of a CFA graph by semPaths.
}
\details{
Modify a \link[qgraph:qgraph]{qgraph::qgraph} object generated by semPaths
based on a confirmatory factor analysis model.
}
\examples{
library(lavaan)
library(semPlot)
mod <-
 'f1 =~ x01 + x02 + x03
  f2 =~ x04 + x05 + x06 + x07
  f3 =~ x08 + x09 + x10
  f4 =~ x11 + x12 + x13 + x14
 '
fit_cfa <- lavaan::sem(mod, cfa_example)
lavaan::parameterEstimates(fit_cfa)[, c("lhs", "op", "rhs", "est", "pvalue")]
p <- semPaths(fit_cfa, whatLabels="est",
       sizeMan = 2.5,
       nCharNodes = 0, nCharEdges = 0,
       edge.width = 0.8, node.width = 0.7,
       edge.label.cex = 0.6,
       style = "ram",
       mar = c(10,10,10,10))
indicator_order  <- c("x04", "x05", "x06", "x07", "x01", "x02", "x03", "x11",
                      "x12", "x13", "x14", "x08", "x09", "x10")
indicator_factor <- c( "f2",  "f2",  "f2",  "f2",  "f1",  "f1",  "f1",  "f4",
                      "f4",  "f4",  "f4",  "f3",  "f3",  "f3")
p2 <- set_cfa_layout(p, indicator_order,
                         indicator_factor,
                         fcov_curve = 1.5,
                         loading_position = .8)
plot(p2)

# Use a named vector for indicator_order
indicator_order2 <- c(f2 = "x04", f2 = "x05", f2 = "x06", f2 = "x07",
                     f1 = "x01", f1 = "x02", f1 = "x03",
                     f4 = "x11", f4 = "x12", f4 = "x13", f4 = "x14",
                     f3 = "x08", f3 = "x09", f3 = "x10")
p2 <- set_cfa_layout(p,
                    indicator_order = indicator_order2,
                    fcov_curve = 1.5,
                    loading_position = .8)
plot(p2)

# Use automatically generated indicator_order and indicator_factor
p2 <- set_cfa_layout(p,
                    fcov_curve = 1.5,
                    loading_position = .8)
plot(p2)

p2 <- set_cfa_layout(p, indicator_order,
                         indicator_factor,
                         fcov_curve = 1.5,
                         loading_position = .8,
                         point_to = "left")
plot(p2)
p2 <- set_cfa_layout(p, indicator_order,
                         indicator_factor,
                         fcov_curve = 1.5,
                         loading_position = .8,
                         point_to = "up")
plot(p2)
p2 <- set_cfa_layout(p, indicator_order,
                         indicator_factor,
                         fcov_curve = 1.5,
                         loading_position = .8,
                         point_to = "right")
plot(p2)

}
