% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pls.R
\name{estimate_pls}
\alias{estimate_pls}
\title{seminr estimate_pls() function}
\usage{
estimate_pls(data,
             measurement_model = NULL, structural_model = NULL, model = NULL,
             inner_weights = path_weighting,
             missing = mean_replacement,
             missing_value = NA,
             maxIt = 300,
             stopCriterion = 7)
}
\arguments{
\item{data}{A \code{dataframe} containing the manifest measurement items in named columns.

The pair of measurement and structural models can optionally be specified as separate model objects}

\item{measurement_model}{An optional \code{measurement_model} object representing the outer/measurement model,
as generated by \code{constructs}.}

\item{structural_model}{An optional \code{smMatrix} object representing the inner/structural model,
  as generated by \code{relationships}.

The pair of measurement and structural models can also be specified as a single \code{specified_model} object}

\item{model}{An optional \code{specified_model} object containing both the the outer/measurement and inner/structural models,
as generated by \code{specify_model}.}

\item{inner_weights}{Function that implements inner weighting scheme:
\code{path_weighting} (default) or \code{path_factorial} can be used.}

\item{missing}{Function that replaces missing values.
\code{mean_replacement} is default.}

\item{missing_value}{Value in dataset that indicates missing values.
NA is used by default.}

\item{maxIt}{A parameter that specifies that maximum number of iterations when estimating the
PLS model. Default value is 300.}

\item{stopCriterion}{A parameter specifying the stop criterion for estimating the PLS model.
Default value is 7.}
}
\value{
A list of the estimated parameters for the SEMinR model including:
 \item{meanData}{A vector of the indicator means.}
 \item{sdData}{A vector of the indicator standard deviations}
 \item{mmMatrix}{A Matrix of the measurement model relations.}
 \item{smMatrix}{A Matrix of the structural model relations.}
 \item{constructs}{A vector of the construct names.}
 \item{mmVariables}{A vector of the indicator names.}
 \item{outer_loadings}{The matrix of estimated indicator loadings.}
 \item{outer_weights}{The matrix of estimated indicator weights.}
 \item{path_coef}{The matrix of estimated structural model relationships.}
 \item{iterations}{A numeric indicating the number of iterations required before the algorithm converged.}
 \item{weightDiff}{A numeric indicating the minimum weight difference between iterations of the algorithm.}
 \item{construct_scores}{A matrix of the estimated construct scores for the PLS model.}
 \item{rSquared}{A matrix of the estimated R Squared for each construct.}
 \item{inner_weights}{The inner weight estimation function.}
 \item{data}{A matrix of the data upon which the model was estimated (INcluding interactions.}
 \item{rawdata}{A matrix of the data upon which the model was estimated (EXcluding interactions.}
 \item{measurement_model}{The SEMinR measurement model specification.}
}
\description{
Estimates a pair of measurement and structural models using PLS-SEM, with optional estimation methods
}
\examples{
mobi <- mobi

#seminr syntax for creating measurement model
mobi_mm <- constructs(
             reflective("Image",        multi_items("IMAG", 1:5)),
             reflective("Expectation",  multi_items("CUEX", 1:3)),
             reflective("Quality",      multi_items("PERQ", 1:7)),
             reflective("Value",        multi_items("PERV", 1:2)),
             reflective("Satisfaction", multi_items("CUSA", 1:3)),
             reflective("Complaints",   single_item("CUSCO")),
             reflective("Loyalty",      multi_items("CUSL", 1:3))
           )
#seminr syntax for creating structural model
mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

mobi_pls <- estimate_pls(data = mobi,
                         measurement_model = mobi_mm,
                         structural_model = mobi_sm,
                         missing = mean_replacement,
                         missing_value = NA)

summary(mobi_pls)
plot_scores(mobi_pls)
}
\seealso{
\code{\link{specify_model}} \code{\link{relationships}} \code{\link{constructs}} \code{\link{paths}} \code{\link{interaction_term}}
         \code{\link{bootstrap_model}}
}
