% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_change_raw_user.R
\name{user_change_raw}
\alias{user_change_raw}
\title{Case Influence on User-Defined Statistics}
\usage{
user_change_raw(rerun_out, user_function = NULL, ...)
}
\arguments{
\item{rerun_out}{The output from \code{\link[=lavaan_rerun]{lavaan_rerun()}}.}

\item{user_function}{A function that accepts a
\code{lavaan}-class object. This function is for computing
user-defined statistics.}

\item{...}{Optional arguments to be
passed to \code{user_function}.}
}
\value{
An \code{est_change}-class object, which is
matrix with the number of columns equals to the number of
values returned by \code{user_function} when computed in one
\code{lavaan}-class object, and the number of rows equals to
the number of cases. The row names are the case
identification values used in
\code{\link[=lavaan_rerun]{lavaan_rerun()}}. The elements are the raw differences.
A print method is available for user-friendly output.
}
\description{
Gets a \code{\link[=lavaan_rerun]{lavaan_rerun()}} output and computes the
changes in user-defined statistics for each case if included.
}
\details{
For each case, \code{\link[=user_change_raw]{user_change_raw()}} computes the differences
in user-defined statistics with and without this
case:

(User statistics with all case) - (User statistics without this case).

The
change is the raw change. The change is \emph{not} divided by standard
error.
This is a measure of the influence of a case on the use-defined
statistics if it is included.

If the value of a case is positive, including
the case increases a statistic.

If the value of a case is negative, including
the case decreases a statistic.

The user-defined statistics are computed by a user-supplied
function, \code{user_function}. It must return a named
vector-like object (which can have only one value).
The output needs to be named, even if it has only one
value.
}
\examples{

# A path model

library(lavaan)
dat <- pa_dat
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
# Fit the model
fit <- sem(mod, dat)
summary(fit)
# Fit the model several times. Each time with one case removed.
# For illustration, do this only for four selected cases
fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = c(2, 4, 7, 9))
# Get the R-squares
lavInspect(fit, what = "rsquare")
out <- user_change_raw(fit_rerun,
                       user_function = lavInspect,
                       what = "rsquare")
out

# Index plot
p <- index_plot(out,
                column = "dv",
                plot_title = "R-square: dv")
p


}
\references{
Pek, J., & MacCallum, R. (2011). Sensitivity analysis
in structural equation models: Cases and their influence.
\emph{Multivariate Behavioral Research, 46}(2), 202-228.
doi:10.1080/00273171.2011.561068
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}.
}
