% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semPower-package.R
\docType{package}
\name{semPower}
\alias{semPower}
\alias{semPower-package}
\title{semPower: Power analyses for structural equation models (SEM).}
\description{
semPower allows for performing a-priori, post-hoc, and compromise power-analyses for structural equation models (SEM).
}
\details{
\itemize{
\item A-priori power analysis \code{\link{semPower.aPriori}} computes the required N, given an effect, alpha, power, and the model df
\item Post-hoc power analysis \code{\link{semPower.postHoc}} computes the achieved power, given an effect, alpha, N, and the model df
\item Compromise power analysis \code{\link{semPower.compromise}} computes the implied alpha and power, given an effect, the alpha/beta ratio, N, and the model df
}

In SEM, the discrepancy between H0 and H1 (the magnitude of effect) refers to the difference in fit between two models. If only one model is defined (which is the default), power refers to the global chi-square test. If both models are explicitly defined, power is computed for nested model tests.  semPower allows for expressing the magnitude of effect by one of the following measures: F0, RMSEA, Mc, GFI, or AGFI.

Alternatively, the implied effect can also be computed from the discrepancy between the population (or a certain model-implied) covariance matrix defining H0 and the hypothesized (model-implied) covariance matrix from a nested model defining H1. See the examples below how to use this feature in conjunction with lavaan.
}
\author{
Morten Moshagen \email{morten.moshagen@uni-ulm.de}
}
