% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_actions.R
\name{open_url}
\alias{open_url}
\title{Open a URL}
\usage{
open_url(url, timeout = 60, session = NULL)
}
\arguments{
\item{url}{The URL to navigate to: a string.}

\item{timeout}{The maximum time to wait for the page to load, in seconds.}

\item{session}{A \code{selenider_session} object. If not specified, the global
session object (the result of \code{\link[=get_session]{get_session()}}) is used.}
}
\value{
The session object, invisibly.
}
\description{
Navigate the browser to specified URL, waiting until the page is considered
open before finishing.
}
\examples{
\dontshow{if (selenider::selenider_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
session <- selenider_session()

open_url("https://r-project.org")

# Or:
open_url(session = session, "https://r-project.org")
\dontshow{\}) # examplesIf}
}
\seealso{
Other global actions: 
\code{\link{back}()},
\code{\link{current_url}()},
\code{\link{execute_js_fn}()},
\code{\link{get_page_source}()},
\code{\link{reload}()},
\code{\link{take_screenshot}()}
}
\concept{global actions}
