% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt_gknown.R
\name{like_gknown_2}
\alias{like_gknown_2}
\title{Likelihood under three parameter model when genotypes are known}
\usage{
like_gknown_2(x, alpha, xi1, xi2, g1, g2, log_p = TRUE, pen = 0)
}
\arguments{
\item{x}{A vector of length 5. \code{x[i]} is the count of individuals with
genotype \code{i-1}.}

\item{alpha}{The double reduction rate.}

\item{xi1}{The preferential pairing parameter of parent 1.}

\item{xi2}{The preferential pairing parameter of parent 2.}

\item{g1}{Parent 1's genotype.}

\item{g2}{Parent 2's genotype.}

\item{log_p}{A logical. Should we return the log likelihood or not?}

\item{pen}{A tiny penalty to help with numerical stability}
}
\value{
The (log) likelihood.
}
\description{
This is under the two parameter model.
}
\examples{
x <- c(1, 4, 5, 3, 1)
alpha <- 0.01
xi1 <- 0.5
xi2 <- 0.3
g1 <- 1
g2 <- 2
like_gknown_2(
  x = x,
  alpha = alpha,
  xi1 = xi1,
  xi2 = xi2,
  g1 = g1,
  g2 = g2)

}
\author{
David Gerard
}
