% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelClass.R
\docType{class}
\name{odeModel-class}
\alias{odeModel-class}
\alias{odeModel}
\title{A class to store the important information of an model.}
\value{
an object of class odeModel which defines the model
}
\description{
The slots are used to store the important information of an model. The class is used to create object for the
two algorithms implemented in seeds. Methods are implemented to easily calculate the nominal solution of the model and
change the details of the saved model.
The numerical solutions are calculated using the \pkg{deSolve} - package.
}
\section{Slots}{

\describe{
\item{\code{func}}{A funtion containing the ode-equations of the model. For syntax look at the given examples of the \pkg{deSolve} package.}

\item{\code{times}}{timesteps at which the model should be evaluated}

\item{\code{parms}}{the parameters of the model}

\item{\code{input}}{matrix containing the inputs with the time points}

\item{\code{measFunc}}{function that converts the output of the ode solution}

\item{\code{y}}{initial (state) values of the ODE system, has to be a vector}

\item{\code{meas}}{matrix with the (experimental) measurements of the system}

\item{\code{sd}}{optional standard deviations of the measurements, is used by the algorithms as weights in the costfunction}

\item{\code{custom}}{customized link function}

\item{\code{nnStates}}{bit vector that indicates if states should be observed by the root function}

\item{\code{nnTollerance}}{tolerance at which a function is seen as zero}

\item{\code{resetValue}}{value a state should be set to by an event}
}}

