% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv_function.R
\name{iv}
\alias{iv}
\title{Param: Index for germination speed}
\usage{
iv(data, trat, nrep, time)
}
\arguments{
\item{data}{Data.frame containing the responses of the evaluations in separate columns side by side and without the columns with the identification of the factors}

\item{trat}{Vector of treatments with n repetitions}

\item{nrep}{Number of repetitions}

\item{time}{Vector containing time}
}
\value{
Returns the vector with the index
}
\description{
Calculates the emergence or germination speed index according to Maguire (1962)
}
\examples{
data("substrate")
iv(substrate[,c(3:18)],
      trat = substrate$Trat,
      nrep = 4,
      time = 1:16)
}
\references{
Maguire JD (1962). Seed of germination - aid in selection and evaluation  for  seedling  emergence  and  vigour.  J  Crop  Sci 2:176-177.
}
