% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.compare_parameters.R
\name{plot.see_compare_parameters}
\alias{plot.see_compare_parameters}
\title{Plot method for comparison of model parameters}
\usage{
\method{plot}{see_compare_parameters}(
  x,
  show_intercept = FALSE,
  size_point = 0.8,
  size_text = NULL,
  dodge_position = 0.8,
  sort = NULL,
  n_columns = NULL,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the intercept-parameter
has a posterior distribution on a very different location, so density curves of
posterior distributions for other parameters are hardly visible.}

\item{size_point}{Size of point-geoms.}

\item{size_text}{Size of text labels.}

\item{dodge_position}{Numeric, indicates the amount of "dodging" (spacing) between geoms.}

\item{sort}{\describe{
  \item{\emph{Plotting model parameters}}{
  If \code{NULL}, coefficients are plotted in the order as they appear in the summary. Use \code{sort = "ascending"} (or \code{sort = TRUE})) resp. \code{sort = "descending"} to sort coefficients in ascending or descending order.
  }
  \item{\emph{Plotting Bayes factors}}{
  Sort pie-slices by posterior probability (descending)?
  }
}}

\item{n_columns}{For models with multiple components (like fixed and random,
count and zero-inflated), defines the number of columns for the
panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::compare_parameters()} function.
}
\examples{
if (require("insight") &&
  require("parameters") &&
  packageVersion("insight") >= "0.13.0") {
  data(iris)
  lm1 <- lm(Sepal.Length ~ Species, data = iris)
  lm2 <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)
  lm3 <- lm(Sepal.Length ~ Species * Petal.Length, data = iris)
  result <- compare_parameters(lm1, lm2, lm3)
  plot(result)
}
}
