% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.effectsize_table.R,
%   R/plot.equivalence_test.R
\name{plot.see_equivalence_test_effectsize}
\alias{plot.see_equivalence_test_effectsize}
\alias{plot.see_equivalence_test}
\alias{plot.see_equivalence_test_lm}
\title{Plot method for (conditional) equivalence testing}
\usage{
\method{plot}{see_equivalence_test_effectsize}(x, ...)

\method{plot}{see_equivalence_test}(
  x,
  rope_color = "#0171D3",
  rope_alpha = 0.2,
  show_intercept = FALSE,
  n_columns = 1,
  ...
)

\method{plot}{see_equivalence_test_lm}(
  x,
  size_point = 0.7,
  rope_color = "#0171D3",
  rope_alpha = 0.2,
  show_intercept = FALSE,
  n_columns = 1,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{...}{Arguments passed to or from other methods.}

\item{rope_color}{Color of ROPE ribbon.}

\item{rope_alpha}{Transparency level of ROPE ribbon.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the intercept-parameter
has a posterior distribution on a very different location, so density curves of
posterior distributions for other parameters are hardly visible.}

\item{n_columns}{For models with multiple components (like fixed and random, count and zero-inflated), defines the number of columns for the panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{size_point}{Size of point-geoms.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{bayestestR::equivalence_test()} function.
}
\examples{
library(effectsize)
m <- aov(mpg ~ factor(am) * factor(cyl), data = mtcars)
result <- eta_squared(m)
plot(result)
}
