% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_recruitment.R
\name{plot_recruitment}
\alias{plot_recruitment}
\title{Plots the recruitment over time for \code{secuTrialdata} objects}
\usage{
plot_recruitment(
  x,
  return_data = FALSE,
  show_centres = TRUE,
  cex = 1,
  rm_regex = ""
)
}
\arguments{
\item{x}{a \code{secuTrialdata} object}

\item{return_data}{logical - return the data used to produce the plot instead of the plot}

\item{show_centres}{logical - subset the data into centres}

\item{cex}{double - specifies font size in legend}

\item{rm_regex}{character - specifies a regular expression to be removed from the centre names in the legend.
e.g. rm_regex = "\\\(.*\\\)$" will remove trailing brackets and their contents.}
}
\value{
a simple line plot showing recruitment over time
        or a list of data.frames if return_data is set to TRUE
}
\description{
secuTrial exports inherently contain the information on which participant was
             registered at which point in time. This function makes use of this property
             to plot recruitment over time. Centers indicated with a black line in the
             legend did not recruit at all.
}
\examples{
# export location
expot_loc <- system.file("extdata", "sT_exports", "lnames",
                         "s_export_CSV-xls_CTU05_long_ref_miss_en_utf8.zip",
                         package = "secuTrialR")
# read export
sT_export <- read_secuTrial(expot_loc)

# plot recruitment
plot_recruitment(sT_export)

# plot without trailing bracket
plot_recruitment(sT_export, rm_regex = "\\\\(.*\\\\)$")

}
