% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secret.R
\name{sha3}
\alias{sha3}
\title{SHA-3 Cryptographic Hash Algorithms}
\usage{
sha3(x, bits = 256L, convert = TRUE, file)
}
\arguments{
\item{x}{object to hash. A character string or raw vector (without
attributes) is hashed as is. All other objects are stream hashed using
native R serialization.}

\item{bits}{integer output size of the returned hash. Must be one of \code{224},
\code{256}, \code{384} or \code{512}.}

\item{convert}{logical \code{TRUE} to convert the hash to its hex representation
as a character string, \code{FALSE} to return directly as a raw vector, or \code{NA}
to return as a vector of (32-bit) integers.}

\item{file}{character file name / path. If specified, \code{x} is ignored. The
file is stream hashed, and the file can be larger than memory.}
}
\value{
A character string, raw or integer vector depending on \code{convert}.
}
\description{
Returns a SHA-3 hash of the supplied object or file.
}
\section{R Serialization Stream Hashing}{


Where this is used, serialization is always version 3 big-endian
representation and the headers (containing R version and native encoding
information) are skipped to ensure portability across platforms.

As hashing is performed in a streaming fashion, there is no materialization
of, or memory allocation for, the serialized object.
}

\examples{
# SHA3-256 hash as character string:
sha3("secret base")

# SHA3-256 hash as raw vector:
sha3("secret base", convert = FALSE)

# SHA3-224 hash as character string:
sha3("secret base", bits = 224)

# SHA3-384 hash as character string:
sha3("secret base", bits = 384)

# SHA3-512 hash as character string:
sha3("secret base", bits = 512)

# SHA3-256 hash a file:
file <- tempfile(); cat("secret base", file = file)
sha3(file = file)
unlink(file)

}
\references{
The SHA-3 Secure Hash Standard was published by the National Institute of
Standards and Technology (NIST) in 2015 at \doi{doi:10.6028/NIST.FIPS.202}.

This implementation is based on one by 'The Mbed TLS Contributors' under the
'Mbed TLS' Trusted Firmware Project at
\url{https://www.trustedfirmware.org/projects/mbed-tls}.
}
