% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets.R
\name{update_secret}
\alias{update_secret}
\title{Update a secret in the vault.}
\usage{
update_secret(name, value, key = local_key(), vault = NULL)
}
\arguments{
\item{name}{Name of the secret.}

\item{value}{Value of the secret, an arbitrary R object that
will be serialized using \code{\link[base:serialize]{base::serialize()}}.}

\item{key}{The private RSA key to use. It defaults to the current
user's default key.}

\item{vault}{Vault location (starting point to find the vault).
To create a vault, use \code{\link[=create_vault]{create_vault()}} or \code{\link[=create_package_vault]{create_package_vault()}}.
If this is \code{NULL}, then \code{secret} tries to find the vault automatically:
\itemize{
\item If the \code{secret.vault} option is set to path, that is used as the
starting point.
\item Otherwise, if the \code{R_SECRET_VAULT} environment variable is set to a
path, that is used as a starting point.
\item Otherwise the current working directory is used as the starting
point.
}

If the starting point is a vault, that is used. Otherwise, if the
starting point is in a package tree, the \code{inst/vault} folder is used
within the package. If no vault can be found, an error is thrown.}
}
\description{
Update a secret in the vault.
}
\seealso{
Other secret functions: \code{\link{add_secret}},
  \code{\link{delete_secret}}, \code{\link{get_secret}},
  \code{\link{list_owners}}, \code{\link{list_secrets}},
  \code{\link{local_key}}, \code{\link{share_secret}},
  \code{\link{unshare_secret}}
}
