\name{seawaveQPlots}
\alias{seawaveQPlots}
\title{Internal function that generates plots of data and model results.}
\usage{
  seawaveQPlots(stpars, cmaxt, tseas, tseaspr, tndlin,
    tndlinpr, cdatsub, cavdat, cavmat, clog, centmp,
    yrstart, yrend, tyr, tyrpr, pnames, tanm, mclass = 1)
}
\arguments{
  \item{stpars}{is a matrix of information about the best
  seawaveQ model for the concentration data, see
  \code{\link{examplestpars}}.}

  \item{cmaxt}{is the decimal season of maximum chemical
  concentration.}

  \item{tseas}{is the decimal season of each concentration
  value in cdatsub.}

  \item{tseaspr}{is the decimal season date used to model
  concentration using the continuous data set cavdat.}

  \item{tndlin}{is the decimal time centered on the
  midpoint of the trend for the sample data, cdatasub.}

  \item{tndlinpr}{is is the decimal time centered on the
  midpoint of the trend for the continuous data, cavdat.}

  \item{cdatsub}{is the concentration data}

  \item{cavdat}{is the continuous (daily) ancillary data}

  \item{cavmat}{is a matrix containing the continuous
  ancillary variables.}

  \item{clog}{is a vector of the base-10 logarithms of the
  concentration data.}

  \item{centmp}{is a logical vector indicating which
  concentration values are censored.}

  \item{yrstart}{is the starting year of the analysis
  (treated as January 1 of that year).}

  \item{yrend}{is the ending year of the analysis (treated
  as December 31 of that year).}

  \item{tyr}{is a vector of decimal dates for the
  concentration data}

  \item{tyrpr}{is a vector of decimal dates for the
  continuous ancillary varaibles.}

  \item{pnames}{is the parameter (water-quality
  constituents) to analyze (if using USGS parameters, omit
  the the starting 'P', such as "00945" for sulfate).}

  \item{tanm}{is an a character identifier that names the
  trend analysis run.  It is used to label output files.}

  \item{mclass}{has not been implemented yet, but will
  provide additional model options.}
}
\value{
  a pdf file containing plots of the data and modeled
  concentrations and regression diagnostic plots and a list
  containing the observed concentrations (censored and
  uncensored) and the predicted concentrations used for the
  plot.
}
\description{
  seawaveQPlots is usually called from within
  \code{\link{fitMod}} but can be invoked directly.  It
  generates plots of data and model results, as well as
  diagnostic plots, and returns the observed and predicted
  concentrations so that users may plot the concentrations
  using their own functions.
}
\note{
  The plotting position used for representing censored
  values in the plots produced by
  \code{\link{seawaveQPlots}} is an important consideration
  for interpreting model fit.  Plotting values obtained by
  using the censoring limit, or something smaller such as
  one-half of the censoring limit, produce plots that are
  difficult to interpret if there are a large number of
  censored values.  Therefore, to make the plots more
  representative of diagnostic plots used for standard
  (non-censored) regression, a method for substituting
  randomized residuals in place of censored residuals was
  used.  If a log-transformed concentration is censored at
  a particular limit, \code{logC < L}, then the residual
  for that concentration is censored as well, \code{logC -
  fitted(logC) < L - fitted(logC) = rescen}.  In that case,
  a randomized residual was generated from a conditional
  normal distribution \cr \cr \code{resran <- scl *
  qnorm(runif(1) * pnorm(rescen / scl))}, \cr \cr where scl
  is the scale parameter from the survival regression
  model, \code{pnorm} is the R function for computing
  cumulative normal probabilities, \code{runif} is the R
  function for generating a random variable from the
  uniform distribution, and \code{qnorm} is the R function
  for computing quantiles of the normal distribution. Under
  the assumption that the model residuals are uncorrelated,
  normally distributed random variables with mean zero and
  standard deviation scl, the randomized residuals
  generated in this manner are an unbiased sample of the
  true (but unknown) residuals for the censored data.  This
  is an application of the probability integral transform
  (Mood and others, 1974) to generate random variables from
  continuous distributions. The plotting position used a
  censored concentration is \code{fitted(logC) + resran}.
  Note that each time a new model fit is performed, a new
  set of randomized residuals is generated and thus the
  plotting positions for censored values can change.
}
\examples{
data(swData)
myPlots <- seawaveQPlots(stpars=examplestpars, cmaxt=0.4808743,
tseas=exampletseas, tseaspr=exampletseaspr, tndlin=exampletndlin,
tndlinpr=exampletndlinpr, cdatsub=examplecdatsub, cavdat=examplecavdat,
cavmat=examplecavmat, clog=exampleclog, centmp=examplecentmp,
yrstart=1995, yrend=2003, tyr=exampletyr, tyrpr=exampletyrpr,
pnames=c("04041"), tanm="examplePlots04041")
}
\author{
  Aldo V. Vecchia and Karen R. Ryberg
}
\references{
  Mood, A.M., Graybill, F.A., and Boes, D.C., 1974,
  Introduction to the theory of statistics (3d ed.): New
  York, McGraw-Hill, Inc., 564 p.
}
\keyword{dplot}
\keyword{hplot}

