% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{toPiInt}
\alias{toPiInt}
\alias{to2PiInt}
\alias{toInt}
\title{Wrapping of radians to its principal values}
\usage{
toPiInt(x)

to2PiInt(x)

toInt(x, a, b)
}
\arguments{
\item{x}{a vector, matrix or object for whom \code{\link[base]{Arithmetic}} is defined.}

\item{a, b}{the lower and upper limits of \eqn{[a, b)}.}
}
\value{
The wrapped vector in the chosen interval.
}
\description{
Utilities for transforming a reals into \eqn{[-\pi, \pi)}, \eqn{[0, 2\pi)} or \eqn{[a, b)}.
}
\details{
Note that \eqn{b} is \bold{excluded} from the result, see examples.
}
\examples{
# Wrapping of angles
x <- seq(-3 * pi, 5 * pi, l = 100)
toPiInt(x)
to2PiInt(x)

# Transformation to [1, 5)
x <- 1:10
toInt(x, 1, 5)
toInt(x + 1, 1, 5)

# Transformation to [1, 5]
toInt(x, 1, 6)
toInt(x + 1, 1, 6)
}
