% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undersample.R
\name{undersample_mclust}
\alias{undersample_mclust}
\title{Undersample a dataset by expectation-maximization clustering}
\usage{
undersample_mclust(data, cls, cls_col, m)
}
\arguments{
\item{data}{Data to be undersampled.}

\item{cls}{Class to be undersampled.}

\item{cls_col}{Class column.}

\item{m}{Number of samples in undersampled dataset.}
}
\value{
The undersampled dataframe containing only instance of \code{cls}.
}
\description{
Undersample a dataset by expectation-maximization clustering
}
\examples{
setosa <- iris[iris$Species == "setosa", ]
nrow(setosa)
undersamp <- undersample_mclust(setosa, "setosa", "Species", 15)
nrow(undersamp)
}
