% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reround-to-fraction.R
\name{fractional-rounding}
\alias{fractional-rounding}
\alias{reround_to_fraction}
\alias{reround_to_fraction_level}
\title{Generalized rounding to the nearest fraction of a specified denominator}
\usage{
reround_to_fraction(
  x = NULL,
  denominator = 1,
  digits = Inf,
  rounding = "up_or_down",
  threshold = 5,
  symmetric = FALSE
)

reround_to_fraction_level(
  x = NULL,
  denominator = 1,
  digits = 0L,
  rounding = "up_or_down",
  threshold = 5,
  symmetric = FALSE
)
}
\arguments{
\item{x}{Numeric. Vector of numbers to be rounded.}

\item{denominator}{Numeric (>= 1) . \code{x} will be rounded to the nearest
fraction of \code{denominator}. Default is \code{1}.}

\item{digits}{Numeric (whole numbers).
\itemize{
\item In \code{reround_to_fraction()}: If \code{digits} is specified, the values
resulting from fractional rounding will subsequently be rounded to that
many decimal places. If set to \code{"auto"}, it internally becomes
\code{ceiling(log10(denominator)) + 1}, as in \code{janitor::round_to_fraction()}.
Default is \code{Inf}, in which case there is no subsequent rounding.
\item In \code{reround_to_fraction_level()}: This function will round to a fraction
of the number at the decimal level specified by \code{digits}. Default is \code{0}.
}}

\item{rounding, threshold, symmetric}{More arguments passed down to
\code{reround()}.}
}
\value{
Numeric vector of the same length as \code{x} unless \code{rounding} is either
of \code{"up_or_down"}, \code{"up_from_or_down_from"}, and \code{"ceiling_or_floor"}. In
these cases, it will always have length 2.
}
\description{
Two functions that round numbers to specific fractions, not just
to the next higher decimal level. They are inspired by
\code{janitor::round_to_fraction()} but feature all the options of \code{reround()}:
\itemize{
\item \code{reround_to_fraction()} closely follows \code{janitor::round_to_fraction()}
by first rounding to fractions of a whole number, then optionally rounding
the result to a specific number of digits in the usual way.
\item \code{reround_to_fraction_level()} rounds to the nearest fraction of a number
at the specific decimal level (i.e., number of digits), without subsequent
rounding. This is closer to conventional rounding functions.
}
}
\examples{
#`reround_to_fraction()` rounds `0.4`
# to `0` if `denominator` is `1`, which
# is the usual integer rounding...
reround_to_fraction(0.4, denominator = 1, rounding = "even")

# ...but if `denominator` is `2`, it rounds to the nearest
# fraction of 2, which is `0.5`:
reround_to_fraction(0.4, denominator = 2, rounding = "even")

# Likewise with fractions of 3:
reround_to_fraction(0.25, denominator = 3, rounding = "even")

# The default for `rounding` is to round
# both up and down, as in `reround()`:
reround_to_fraction(0.4, denominator = 2)

# These two rounding procedures differ
# at the tie points:
reround_to_fraction(0.25, denominator = 2)

# `reround_to_fraction_level()`, in contrast,
# uses `digits` to determine some decimal level,
# and then rounds to the closest fraction at
# that level:
reround_to_fraction_level(0.12345, denominator = 2, digits = 0)
reround_to_fraction_level(0.12345, denominator = 2, digits = 1)
reround_to_fraction_level(0.12345, denominator = 2, digits = 2)
}
\seealso{
\code{reround()}, which the functions wrap, and
\code{janitor::round_to_fraction()}, part of which they copy.
}
