% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{kmeanspp}
\alias{kmeanspp}
\title{Perform the k-means++ algorithm}
\usage{
kmeanspp(x, n_cluster, n_init_clusterings = 10L, n_max_iter = 10L)
}
\arguments{
\item{x}{Input matrix (n x p)}

\item{n_cluster}{Number of clusters}

\item{n_init_clusterings}{Number of repeated random initializations
to perform}

\item{n_max_iter}{Number of maximum iterations to perform in the k-means
algorithm}
}
\value{
An object of class \code{\link[stats:kmeans]{stats::kmeans}}.
}
\description{
Performs the k-means++ algorithm to cluster the rows of the input matrix.
}
\details{
Estimation is repeated
}
\references{
David Arthur and Sergei Vassilvitskii. K-Means++: The advantages
of careful seeding. In Proceedings of the Eighteenth Annual ACM-SIAM
Symposium on Discrete Algorithms, SODA '07, pages 1027––1035.
Society for Industrial and Applied Mathematics, 2007.
}
\concept{helpers}
