% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perf.R
\name{perf_eva}
\alias{perf_eva}
\title{KS, ROC, Lift, PR}
\usage{
perf_eva(label, pred, title = NULL, groupnum = NULL, type = c("ks",
  "roc"), show_plot = TRUE, positive = "bad|1", seed = 186)
}
\arguments{
\item{label}{Label values, such as 0s and 1s, 0 represent for good and 1 for bad.}

\item{pred}{Predicted probability or score.}

\item{title}{Title of plot, default is NULL.}

\item{groupnum}{The group number when calculating KS.  Default NULL, which means the number of sample size.}

\item{type}{Types of performance plot, such as "ks", "lift", "roc", "pr". Default c("ks", "roc").}

\item{show_plot}{Logical value, default is TRUE. It means whether to show plot.}

\item{positive}{Value of positive class, default is "bad|1".}

\item{seed}{Integer, default is 186. The specify seed is used for random sorting data.}
}
\value{
ks, roc, lift, pr
}
\description{
\code{perf_eva} provides performance evaluations, such as kolmogorov-smirnow(ks), ROC, lift and precision-recall curves, based on provided label and predicted probability values.
}
\details{
Accuracy = true positive and true negative/total cases

Error rate = false positive and false negative/total cases

TPR, True Positive Rate(Recall or Sensitivity) = true positive/total actual positive

PPV, Positive Predicted Value(Precision) = true positive/total predicted positive

TNR, True Negative Rate(Specificity) = true negative/total actual negative

NPV, Negative Predicted Value = true negative/total predicted negative
}
\examples{
\dontrun{
# load germancredit data
data("germancredit")

# filter variable via missing rate, iv, identical value rate
dt_sel = var_filter(germancredit, "creditability")

# woe binning ------
bins = woebin(dt_sel, "creditability")
dt_woe = woebin_ply(dt_sel, bins)

# glm ------
m1 = glm( creditability ~ ., family = binomial(), data = dt_woe)
# summary(m1)

# Select a formula-based model by AIC
m_step = step(m1, direction="both", trace=FALSE)
m2 = eval(m_step$call)
# summary(m2)

# predicted proability
dt_pred = predict(m2, type='response', dt_woe)

# performance ------
# Example I # only ks & auc values
perf_eva(dt_woe$creditability, dt_pred, show_plot=FALSE)

# Example II # ks & roc plot
perf_eva(dt_woe$creditability, dt_pred)

# Example III # ks, lift, roc & pr plot
perf_eva(dt_woe$creditability, dt_pred, type = c("ks","lift","roc","pr"))
}
}
\seealso{
\code{\link{perf_psi}}
}
