% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{scico}
\alias{scico}
\title{Scientific colour map palettes}
\usage{
scico(n, alpha = NULL, begin = 0, end = 1, direction = 1, palette = "bilbao")
}
\arguments{
\item{n}{The number of colours to generate for the palette}

\item{alpha}{The opacity of the generated colours. If specified rgba values
will be generated. The default (\code{NULL}) will generate rgb values which
corresponds to \code{alpha = 1}}

\item{begin, end}{The interval within the palette to sample colours from.
Defaults to \code{0} and \code{1} respectively}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed}

\item{palette}{The name of the palette to sample from. See
\code{\link[=scico_palette_names]{scico_palette_names()}} for a list of possible names}
}
\value{
A character vector of length \code{n} with hexencoded rgb(a) colour values
}
\description{
This function constructs palettes of the specified size based on the colour
maps developed by Fabio Crameri. It follows the same API style as \code{viridis()}
from the \code{viridisLite} package so anyone familiar with this package can
easily adapt to that.
}
\examples{

# Use the default palette
scico(15)

# Flip the direction
scico(15, direction = -1)

# Take a subset of a palette
scico(15, begin = 0.3, end = 0.6, palette = 'berlin')

}
\references{
\url{http://www.fabiocrameri.ch/colourmaps.php}

Crameri, Fabio. (2018, May 8). \emph{Scientific colour maps (Version 3.0.1)}. Zenodo. \doi{10.5281/zenodo.1243909}
Crameri, Fabio. (2018). \emph{Geodynamic diagnostics, scientific visualisation and StagLab 3.0}. Geosci. Model Dev. Discuss. \doi{10.5194/gmd-2017-328}
}
