% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_points_histogram.R
\name{scatter_points_histogram}
\alias{scatter_points_histogram}
\title{scatter_points_histogram}
\usage{
scatter_points_histogram(
  xy,
  xlim = c(min(xy[, 1]), max(xy[, 1])),
  ylim = c(min(xy[, 2]), max(xy[, 2])),
  out_size = c(512L, 512L)
)
}
\arguments{
\item{xy}{2-column matrix with point coordinates. As usual with
rasters in R, X axis grows right, and Y axis grows DOWN.
Flipping \code{ylim} causes the "usual" mathematical behavior.}

\item{xlim}{Limits as usual (position of the first pixel on the
left/top, and the last pixel on the right/bottom), 2-element vector.
You can easily flip the top/bottom to the "usual" mathematical
system by flipping the \code{ylim} vector.}

\item{ylim}{Limits as usual (position of the first pixel on the
left/top, and the last pixel on the right/bottom), 2-element vector.
You can easily flip the top/bottom to the "usual" mathematical
system by flipping the \code{ylim} vector.}

\item{out_size}{2-element vector size of the result histogram,
defaults to \code{c(512,512)}.}
}
\value{
Histogram with the result.
}
\description{
Create histogram from given point coordinates.
}
