% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scapeForSeurat.R
\name{scapeForSeurat}
\alias{scapeForSeurat}
\title{Cytokine activity scores for a Seurat matrix.}
\usage{
scapeForSeurat(
  seurat.object,
  database = "cytosig",
  cytokine = "all",
  normalize = TRUE
)
}
\arguments{
\item{seurat.object}{Seurat counts matrix.}

\item{database}{Database used for gene set construction and set scoring.
\itemize{
\item "cytosig" (default) performs scoring for up to 41 cytokines using the CytoSig database.
\item "reactome" performs scoring for up to 30 cytokines using the Reactome database.
}}

\item{cytokine}{Vector of cytokine names to score for activity. The default value of "all"
will score all 41 cytokines supported by CytoSig or 31 supported by Reactome. Please see
function \code{\link[scaper]{supportedCytokines}} to view all the CytoSig or the Reactome
specific scored cytokines.}

\item{normalize}{Boolean indicator for whether normalization should be performed before performing gene set scoring.}
}
\value{
Seurat object consisting of cell-level cytokine activity scores returned as a separate assay (scape for scoring via the CytoSig database and VAMcdf for scoring via the Reactome database).
}
\description{
Computes cell-level estimates of cytokine activity for a scRNA-seq Seurat
count matrix using the scapeForSeurat method. SCAPE activity estimates are computed by scoring weighted gene
sets from the CytoSig or Reactome databases using the Variance-adjusted Mahalanobis (VAM) method
as implemented in the \code{\link[VAM:vamForSeurat]{VAM::vamForSeurat()}} function. Individual gene sets for subsequent scoring can be reconstructed using
the \code{\link[scaper]{genesetCytoSig}} and the \code{\link[scaper]{genesetReactome}} functions
for the CytoSig and the Reactome database, respectively.
}
\examples{
library(SeuratObject)
CytoSig.score.output.all <- scapeForSeurat(seurat.object = pbmc_small, 
database = "cytosig", cytokine = "all", normalize=TRUE)
(as.data.frame(CytoSig.score.output.all@assays$scape@data))[1:6,1:3]
CytoSig.score.output.specific <- scapeForSeurat(seurat.object = pbmc_small, 
database = "cytosig", cytokine = c("IL4", "IL13"), normalize=TRUE)
(as.data.frame(CytoSig.score.output.specific@assays$scape@data))[,1:3]

}
\seealso{
{\code{\link{genesetCytoSig}}, \code{\link{genesetReactome}}, \code{\link{scape}}}
}
