% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_poisson.R
\name{poisson_mcsim}
\alias{poisson_mcsim}
\title{Monte Carlo simulation of expectation-based Poisson scan statistics.}
\usage{
poisson_mcsim(table, zones, n_mcsim = 999L)
}
\arguments{
\item{table}{A \code{data.table} with columns \code{location, duration, mu}.}

\item{zones}{A \code{set} of zones, each zone itself being a \code{set}
containing locations. Locations should be encoded as integers.}

\item{n_mcsim}{A positive integer; the number of replicate scan 
statistics to generate.}
}
\value{
A numeric vector of length \code{n_mcsim}.
}
\description{
This function generates \code{n_mcsim} Poisson-distributed data sets 
according to the parameters in the input table, and calculates the value of
the scan statistic for each generated data set using the supplied 
\code{zones}.
}
\keyword{internal}

