% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-standardize.R
\name{standardize}
\alias{standardize}
\title{Standardize values of an scdf file}
\usage{
standardize(
  data,
  var,
  center = TRUE,
  scale = FALSE,
  m = 0,
  sd = 1,
  grand = TRUE
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{var}{A character string or a vector of character strings with variable
names that should be scaled.}

\item{center}{If set TRUE, data are mean centered.}

\item{scale}{If set TRUE, the standard deviation is set.}

\item{m}{The target mean for centering.}

\item{sd}{The target standard deviation for scaling}

\item{grand}{If set TRUE, scaling is based on the mean and standard deviation
of all values across all single-cases within the scdf.}
}
\value{
An scdf with the scaled values.
}
\description{
\emph{This function is superseded by the much more versatile
\code{\link{transform.scdf}} function (see example below).}
This function scales the measured values of an scdf file. It allows for mean
centering and standardization based on each single-case data set or a
scaling across all cases included in an scdf.
}
\examples{

## Standardize a multiple case scdf and compute an hplm
exampleAB_50 |>
  standardize("values", center = TRUE, scale = TRUE) |>
  hplm()

## The more versatile transform function supersedes standardize:
exampleAB_50 |>
  transform(values = (values - mean(all(values))) / sd(all(values))) |>
  hplm()
}
\seealso{
Other data manipulation functions: 
\code{\link{add_l2}()},
\code{\link{as.data.frame.scdf}()},
\code{\link{as_scdf}()},
\code{\link{fill_missing}()},
\code{\link{moving_median}()},
\code{\link{outlier}()},
\code{\link{ranks}()},
\code{\link{rescale}()},
\code{\link{scdf}()},
\code{\link{select_cases}()},
\code{\link{set_vars}()},
\code{\link{shift}()},
\code{\link{smooth_cases}()},
\code{\link{truncate_phase}()}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
\keyword{internal}
