% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pet.R
\name{pet}
\alias{pet}
\title{Percent exceeding the trend}
\usage{
pet(data, dvar, pvar, mvar, ci = 0.95, decreasing = FALSE, phases = c(1, 2))
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{ci}{Width of the confidence interval. Default is \code{ci = 0.95}.}

\item{decreasing}{If you expect data to be lower in the B phase, set
\code{decreasing = TRUE}. Default is \code{decreasing = FALSE}.}

\item{phases}{A vector of two characters or numbers indicating the two phases
that should be compared. E.g., \code{phases = c("A","C")} or \code{phases =
c(2,4)} for comparing the second to the fourth phase. Phases could be
combined by providing a list with two elements. E.g., \code{phases = list(A
= c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2 and 4
(as B). Default is \code{phases = c(1,2)}.}
}
\value{
\item{PET}{Percent exceeding the trend.} \item{PET.ci}{Percent
exceeding the upper / lower 95\%-CI boundary.} \item{p}{P value of Binomial
Test.} \item{ci.percent}{Width of confidence interval in percent.}
\item{se.factors}{Standard error.} \item{N}{Number of cases.}
\item{decreasing}{Logical argument from function call (see \code{Arguments}
above).} \item{case.names}{Assigned name of single-case.} \item{phases}{-}
}
\description{
The \code{pet} function provides the percentage of phase B data points
exceeding the prediction based on the phase A trend. A binomial test against
a 50/50 distribution is computed. Furthermore, the percentage of phase B
data points exceeding the upper (or lower) 95 percent confidence interval of
the predicted progress is computed.
}
\examples{

## Calculate the PET and use a 99\%-CI for the additional calculation
# create random example data
design <- design(n = 5, slope = 0.2)
dat <- random_scdf(design, seed = 23)
pet(dat, ci = .99)

}
\seealso{
Other overlap functions: 
\code{\link{corrected_tau}()},
\code{\link{nap}()},
\code{\link{overlap}()},
\code{\link{pand}()},
\code{\link{pem}()},
\code{\link{pnd}()},
\code{\link{tau_u}()}
}
\author{
Juergen Wilbert
}
\concept{overlap functions}
