% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_helper.R
\name{getScalpelStep1}
\alias{getScalpelStep1}
\title{Read in results from Step 1 of SCALPEL.}
\usage{
getScalpelStep1(outputFolder, version = NULL)
}
\arguments{
\item{outputFolder}{The existing directory where the results that the user wishes to use are saved.}

\item{version}{The 5-digit folder ID for the results that the user wishes to load. If NULL, automatically chooses
the only version in outputFolder and if more than one version exists, returns an error.}
}
\value{
An object of class \code{scalpelStep1}, which can be used to run SCALPEL Step 2 using \code{\link{scalpelStep2}}
or can be used with the plotting function \code{\link{plotCandidateFrame}}.
}
\description{
This step allows the user to retrieve the object of class \code{scalpelStep1} for results from a previous session.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function
#folder where results were saved
outputFolder = "scalpelResults"

#read previous results in
out = getScalpelStep1(outputFolder = outputFolder)
#note: if Step 1 has been run more than once, will need to specify 'version'
}

}
\seealso{
\code{\link{scalpelStep1}}, \code{\link{scalpel}}
}

