% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconvolute_and_contextualize.R
\name{deconvolute_and_contextualize}
\alias{deconvolute_and_contextualize}
\title{Generate cell weighted Fold-Changes (cwFold-changes)}
\usage{
deconvolute_and_contextualize(
  count_file,
  signature_matrix,
  DEG_list,
  case_grep,
  control_grep,
  max_proportion_change = -9,
  print_plots = T,
  plot_names = "scMappR",
  theSpecies = "human",
  make_scale = FALSE,
  FC_coef = T,
  sig_matrix_size = 3000,
  sig_distort = 1,
  drop_unknown_celltype = TRUE,
  toSave = FALSE,
  path = NULL
)
}
\arguments{
\item{count_file}{Normalized deconvolute_and_contextualize. RNA-seq count matrix where rows are gene symbols and columns are individuals. Either the object tself of the path of a .tsv file.}

\item{signature_matrix}{Signature matrix (recommended odds ratios) of cell-type specificity of genes. Either the object itself or a pathway to a .RData file containing an object named "wilcoxon_rank_mat_or" - generally internal.}

\item{DEG_list}{An object with the first column as gene symbols within the bulk dataset (doesn't have to be in signature matrix), second column is the adjusted P-value, and the third the log2FC. Path to a tsv file containing this info is also acceptable.}

\item{case_grep}{Tag in the column name for cases (i.e. samples representing upregulated) OR an index of cases.}

\item{control_grep}{Tag in the column name for control (i.e. samples representing downregulated) OR an index of cases.}

\item{max_proportion_change}{Maximum cell-type proportion change. May be useful if there are many rare cell-types.}

\item{print_plots}{Whether boxplots of the estimated CT proportion for the leave-one-out method of CT deconvolution should be printed (T/F).}

\item{plot_names}{If plots are being printed, the pre-fix of their .pdf files.}

\item{theSpecies}{-9 if using a precomputed count matrix from scMappR, human otherwise. Removes ensembl symbols if appended.}

\item{make_scale}{Convert the lowest odds ratio to 1 and scales accordingly -- strongly not recommended and will produce warning if used.}

\item{FC_coef}{Making cwFold-changes based on fold-change (TRUE) or rank := (-log10(Pval)) (FALSE) rank. After testing, we strongly recommend to keep true (T/F).}

\item{sig_matrix_size}{Number of genes in signature matrix for cell-type deconvolution.}

\item{sig_distort}{Exponential change of odds ratios. Strongly not recomended and will produce warnings if changed from default.}

\item{drop_unknown_celltype}{Whether or not to remove "unknown" cell-types from the signature matrix (T/F).}

\item{toSave}{Allow scMappR to write files in the current directory (T/F).}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}
}
\value{
List with the following elements:
\item{cellWeighted_Foldchange}{data frame of cellweightedFold changes for each gene.}
\item{cellType_Proportions}{data frame of cell-type proportions from DeconRNA-seq.}
\item{leave_one_out_proportions}{data frame of average cell-type proportions for case and control when gene is removed.}
\item{processed_signature_matrix}{signature matrix used in final analysis.}
}
\description{
This function takes a count matrix, signature matrix, and differentially expressed genes (DEGs) before generating cwFold-chagnes for each cell-type.
}
\details{
This function completes the cell-type contextualization in scMappR -- reranking every DEG based on their fold change, likelihood the gene is in each detected cell-type, average cell-type proportion, and ratio of cell-type proportion between case and control.
If a gene is upregulated then it is being controlled by control/case, otherwise it is case/control.
cwFold-change's are generated for genes that are in both the count matrix and in the list of DEGs. It does not have to also be in the signature matrix.
First, this function will estimate cell-type proportions with all genes included before estimating changes in cell-type proportion between case/control using a t-test.
Then, it takes a leave-one-out approach to cell-type deconvolution such that estimated cell-type proportions are computed for every inputted DEG.
Optionally, the differences between cell-type proprtion before and after a gene is removed is plotted in boxplots.
Then, for every gene, cwFold-change's are computed with the following formula (the example for upreguatled genes)
val <- cell-preferences * cell-type_proprtion * cell-type_proportion_fold-change * sign*2^abs(gene_DE$log2fc).
A matrix of cwFold-change's for all DEGs are returned.
}
\examples{
\donttest{
data(PBMC_example)
bulk_DE_cors <- PBMC_example$bulk_DE_cors
bulk_normalized <- PBMC_example$bulk_normalized
odds_ratio_in <- PBMC_example$odds_ratio_in
case_grep <- "_female"
control_grep <- "_male"
max_proportion_change <- 10
print_plots <- FALSE
theSpecies <- "human"
norm <- deconvolute_and_contextualize(bulk_normalized, odds_ratio_in, bulk_DE_cors,
                                    case_grep = case_grep, control_grep = control_grep,
                                     max_proportion_change = max_proportion_change,
                                      print_plots = print_plots, 
                                     theSpecies = theSpecies, toSave = FALSE)

}                                      
}
