% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCR.ContigList.R
\name{BCR.ContigList}
\alias{BCR.ContigList}
\title{Converting 10X genomics produced B cell contigs file(s) as a list outputed}
\usage{
BCR.ContigList(datasetDir, sampleName, groupName)
}
\arguments{
\item{datasetDir}{The single-cell samples' directory containing file filtered_contig_annotations.csv.}

\item{sampleName}{The sample name of single cell sample.}

\item{groupName}{The group name of single cell sample.}
}
\value{
List of clonotypes for individual cell barcodes.
}
\description{
Converting 10X genomics produced B cell contigs file(s) as a list outputed
}
\examples{

project_data_dir <- "F:/R_Language/data/bcr"
sample_name <- list.dirs(project_data_dir, full.names = FALSE, recursive = FALSE)
group_name <- c("A", "A", "B", "B")

TCR.ContigList(project_data_dir, sample_name, group_name)
}
