% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_gsea.R
\name{run_gsea_one_factor}
\alias{run_gsea_one_factor}
\title{Run gsea separately for all cell types of one specified factor and plot results}
\usage{
run_gsea_one_factor(
  container,
  factor_select,
  method = "fgsea",
  thresh = 0.05,
  db_use = "GO",
  signed = TRUE,
  min_gs_size = 15,
  max_gs_size = 500,
  reset_other_factor_plots = FALSE,
  draw_plot = TRUE,
  ncores = container$experiment_params$ncores
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{factor_select}{numeric The factor of interest}

\item{method}{character The method of gsea to use. Can either be "fgsea",
"fgsea_special or "hypergeometric". (default="fgsea")}

\item{thresh}{numeric Pvalue significance threshold to use. Will include gene sets in
resulting heatmap if pvalue is below this threshold for at least one cell type. (default=0.05)}

\item{db_use}{character The database of gene sets to use. Database
options include "GO", "Reactome", "KEGG", and "BioCarta". More than
one database can be used. (default="GO")}

\item{signed}{logical If TRUE, uses signed gsea. If FALSE, uses unsigned gsea.
Currently only works with fgsea method (default=TRUE)}

\item{min_gs_size}{numeric Minimum gene set size (default=15)}

\item{max_gs_size}{numeric Maximum gene set size (default=500)}

\item{reset_other_factor_plots}{logical Set to TRUE to set all other gsea plots to NULL (default=FALSE)}

\item{draw_plot}{logical Set to TRUE to show the plot. Plot is stored regardless. (default=TRUE)}

\item{ncores}{numeric The number of cores to use (default=container$experiment_params$ncores)}
}
\value{
A stacked heatmap plot of the gsea results in the slot
container$plots$gsea$<Factor#>. The heatmaps show adjusted p-values for the
enrichment of each gene set in each cell type for the selected factor. The top
heatmap shows enriched gene sets among the positive loading genes and the bottom
heatmap shows enriched gene sets among the negative loading genes for the factor.
}
\description{
Run gsea separately for all cell types of one specified factor and plot results
}
\examples{
test_container <- run_gsea_one_factor(test_container, factor_select=1,
method="fgsea", thresh=0.05, db_use="Hallmark", signed=TRUE)
}
