% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_LR_interact.R
\name{check_rec_pres}
\alias{check_rec_pres}
\title{Helper function to check whether receptor is present in target cell type}
\usage{
check_rec_pres(
  container,
  lig_ct_exp,
  rec_elements,
  target_ct,
  percentile_exp_rec
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{lig_ct_exp}{numeric Scaled expression for a ligand in the source cell type}

\item{rec_elements}{character One or more components of a receptor complex}

\item{target_ct}{character The name of the target cell type}

\item{percentile_exp_rec}{numeric The percentile of ligand expression above which
all donors need to have at least 5 cells expressing the receptor.}
}
\value{
A logical indicating whether receptor is present or not.
}
\description{
Helper function to check whether receptor is present in target cell type
}
