% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_&_Write_Data.R
\name{Read_Add_cNMF}
\alias{Read_Add_cNMF}
\title{Read and add results from cNMF}
\usage{
Read_Add_cNMF(
  seurat_object,
  usage_file,
  spectra_file,
  normalize = TRUE,
  assay = NULL
)
}
\arguments{
\item{seurat_object}{Seurat object name to add cNMF reduction}

\item{usage_file}{path and name of cNMF usage file}

\item{spectra_file}{path and name of cNMF spectra file}

\item{normalize}{logical, whether to normalize the cNMF usage data, default is TRUE}

\item{assay}{assay to add reduction.  Default is NULL and will use current
active assay.}
}
\value{
Seurat object with new dimensionality reduction "cnmf"
}
\description{
Reads the usage and spectra files from cNMF results and adds them as dimensionality
reduction to seurat object.
}
\examples{
\dontrun{
object <- Read_cNMF(seurat_object = object,
usage_file = "example_cNMF/example_cNMF.usages.k_27.dt_0_01.consensus.txt",
spectra_file = "example_cNMF/example_cNMF.gene_spectra_score.k_27.dt_0_01.txt")
}

}
\references{
For more information about cNMF and usage see \url{https://github.com/dylkot/cNMF}
}
\concept{read_&_write}
