% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_items.R
\name{query_item_identifier}
\alias{query_item_identifier}
\title{Query SB for items based on custom identifier}
\usage{
query_item_identifier(scheme, type = NULL, key = NULL, ..., limit = 20)
}
\arguments{
\item{scheme}{The identifier scheme}

\item{type}{(optional) The identifier type}

\item{key}{(optional) The identifier key}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}}

\item{limit}{Max number of matching items to return}
}
\value{
The SB item id for the matching item. NULL if no matching item found.
}
\description{
Find all items under a scheme or also query by for a specific type and key
}
\examples{
\dontrun{
authenticate_sb()

ex_item = item_create(title='identifier example')
item_update_identifier(ex_item, 'project1', 'dataset1', 'key1')
ex2_item = item_create(title='identifier example 2')
item_update_identifier(ex2_item, 'project1', 'dataset1', 'key2')


#query the specific item
query_item_identifier('project1', 'dataset1', 'key1')

#or get the collection of items based on the ID hierarchy
query_item_identifier('project1')

item_rm(ex_item)
item_rm(ex2_item)
}

}
