% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_pe.r
\name{sampled_2d_ple_analysis}
\alias{sampled_2d_ple_analysis}
\title{2D profile likelihood estimation analysis.}
\usage{
sampled_2d_ple_analysis(model, filename, parameter1, parameter2, plots_dir,
  thres = "BestFits", best_fits_percent = 50,
  fileout_param_estim_summary = "", logspace = TRUE,
  scientific_notation = TRUE)
}
\arguments{
\item{model}{the model name}

\item{filename}{the filename containing the fits sequence}

\item{parameter1}{the name of the first parameter}

\item{parameter2}{the name of the second parameter}

\item{plots_dir}{the directory for storing the plots}

\item{thres}{the threshold used to filter the dataset. Values: "BestFits", "CL66", "CL95", "CL99", "All".}

\item{best_fits_percent}{the percent of best fits to analyse. Only used if thres="BestFits".}

\item{fileout_param_estim_summary}{the name of the file containing the summary for the parameter estimation. Only used if thres!="BestFits".}

\item{logspace}{true if the parameters should be plotted in logspace}

\item{scientific_notation}{true if the axis labels should be plotted in scientific notation}
}
\description{
2D profile likelihood estimation analysis.
}
\examples{
dir.create(file.path("pe_datasets"))
dir.create(file.path("pe_plots"))
data(insulin_receptor_all_fits)
write.table(insulin_receptor_all_fits, 
            file=file.path("pe_datasets", "all_fits.csv"), 
            row.names=FALSE)
# generate the global statistics for the parameter estimation
pe_ds_preproc(filename=file.path("pe_datasets", "all_fits.csv"), 
              param.names=c('k1', 'k2', 'k3'), 
              logspace=TRUE, 
              all.fits=TRUE, 
              data_point_num=33, 
              fileout_param_estim_summary=file.path("pe_datasets", "param_estim_summary.csv"))
sampled_2d_ple_analysis(model="ir_beta", 
                        filename=file.path("pe_datasets", "all_fits_log10.csv"), 
                        parameter1="k1",
                        parameter2="k2", 
                        plots_dir="pe_plots", 
                        thres="CL95",
                        fileout_param_estim_summary=file.path("pe_datasets", 
                                                              "param_estim_summary.csv"),
                        logspace=TRUE)
                           
data(insulin_receptor_best_fits)
write.table(insulin_receptor_best_fits, 
            file=file.path("pe_datasets", "best_fits.csv"), 
            row.names=FALSE)
# generate the global statistics for the parameter estimation
pe_ds_preproc(filename=file.path("pe_datasets", "best_fits.csv"), 
              param.names=c('k1', 'k2', 'k3'), 
              logspace=TRUE, 
              all.fits=FALSE)
sampled_2d_ple_analysis(model="ir_beta", 
                        filename=file.path("pe_datasets", "best_fits_log10.csv"), 
                        parameter1="k1",
                        parameter2="k2",
                        plots_dir="pe_plots", 
                        thres="BestFits",
                        best_fits_percent=50,
                        logspace=TRUE)
}
