% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_plots.r
\name{plot_combined_tc}
\alias{plot_combined_tc}
\title{Plot repeated time courses in the same plot with mean, 1 standard deviation, and 95\% confidence intervals.}
\usage{
plot_combined_tc(df, g = ggplot(), title = "", xaxis_label = "",
  yaxis_label = "", bar_type = "mean", alpha = 1, yaxis.min = NULL,
  yaxis.max = NULL)
}
\arguments{
\item{df}{a data frame}

\item{g}{the current ggplot to overlap}

\item{title}{the title}

\item{xaxis_label}{the xaxis label}

\item{yaxis_label}{the yaxis label}

\item{bar_type}{the type of bar ("mean", "mean_sd", "mean_sd_ci95")}

\item{alpha}{the amount of alpha transparency}

\item{yaxis.min}{the lower limit for the y axis}

\item{yaxis.max}{the upper limit for the y axis}
}
\value{
the plot
}
\description{
Plot repeated time courses in the same plot with mean, 1 standard deviation, and 95\% confidence intervals.
}
\examples{
data(insulin_receptor_1)
data(insulin_receptor_2)
data(insulin_receptor_3)
df <- data.frame(Time=insulin_receptor_1[,1], 
                 X1=insulin_receptor_1[,2], 
                 X2=insulin_receptor_2[,2], 
                 X3=insulin_receptor_3[,2])
plot_combined_tc(df=df, 
                 xaxis_label="Time [m]", yaxis_label="Level [a.u.]", 
                 bar_type="mean", alpha=1, yaxis.min=NULL, yaxis.max=NULL)
plot_combined_tc(df=df, 
                 xaxis_label="Time [m]", yaxis_label="Level [a.u.]", 
                 bar_type="mean_sd", alpha=1, yaxis.min=NULL, yaxis.max=NULL)
plot_combined_tc(df=df, 
                 xaxis_label="Time [m]", yaxis_label="Level [a.u.]", 
                 bar_type="mean_sd_ci95", alpha=0.3, yaxis.min=NULL, yaxis.max=NULL)
}
