% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-SBM.R
\name{SBM}
\alias{SBM}
\title{R6 virtual class for SBM representation (mother class of SimpleSBM, BipartiteSBM, MultipartiteSBM)}
\description{
R6 virtual class for SBM representation (mother class of SimpleSBM, BipartiteSBM, MultipartiteSBM)

R6 virtual class for SBM representation (mother class of SimpleSBM, BipartiteSBM, MultipartiteSBM)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{modelName}}{character, the family of model for the distribution of the edges}

\item{\code{directed}}{mode of the network data (directed or not or not applicable)}

\item{\code{dimLabels}}{vector or list of characters, the label of each dimension}

\item{\code{nbNodes}}{vector describing the number of the successive elements connecting the network}

\item{\code{nbCovariates}}{integer, the number of covariates}

\item{\code{blockProp}}{block proportions (aka prior probabilities of each block)}

\item{\code{connectParam}}{parameters associated to the connectivity of the SBM, e.g. matrix of inter/inter block probabilities when model is Bernoulli}

\item{\code{covarParam}}{vector of regression parameters associated with the covariates.}

\item{\code{covarList}}{list of matrices of covariates}

\item{\code{covarArray}}{the array of covariates}

\item{\code{covarEffect}}{effect of covariates}

\item{\code{networkData}}{the network data (adjacency or incidence matrix or list of such object)}

\item{\code{expectation}}{expected values of connection under the current model}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SBM$new()}}
\item \href{#method-rNetwork}{\code{SBM$rNetwork()}}
\item \href{#method-show}{\code{SBM$show()}}
\item \href{#method-print}{\code{SBM$print()}}
\item \href{#method-clone}{\code{SBM$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for SBM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM$new(
  model = vector("character", 0),
  directed = vector("logical", 0),
  dimension = vector("numeric", 0),
  dimLabels = vector("character", 0),
  blockProp = vector("numeric", 0),
  connectParam = vector("list", 0),
  covarParam = numeric(length(covarList)),
  covarList = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{character describing the type of model}

\item{\code{directed}}{logical describing if the network data is directed or not}

\item{\code{dimension}}{dimension of the network data}

\item{\code{dimLabels}}{labels of each dimension}

\item{\code{blockProp}}{parameters for block proportions (vector or list of vectors)}

\item{\code{connectParam}}{list of parameters for connectivity}

\item{\code{covarParam}}{optional vector of covariates effect}

\item{\code{covarList}}{optional list of covariates data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rNetwork"></a>}}
\if{latex}{\out{\hypertarget{method-rNetwork}{}}}
\subsection{Method \code{rNetwork()}}{
a method to sample a network data for the current SBM (blocks and edges)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM$rNetwork(store = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{store}}{should the sampled network be stored (and overwrite the existing data)? Default to FALSE}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list with the sampled block and network
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM$show(type = "Stochastic Block Model")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character to tune the displayed name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
