% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/calcDODN.R
\name{calcDODN}
\alias{calcDODN}
\title{Compile dark object DN for given sensor band}
\usage{
calcDODN(band)
}
\arguments{
\item{band}{raster::RasterLayer with sensor band data, e.g. returned by
\code{\link{getSatDataLayer}}.}
}
\value{
Numeric value of the DN for the dark object.
}
\description{
The function estimates the DN value of a "dark object" which is used for
atmospheric correction using the DOS2 and DOS4 model. Therefore, the
frequency distribution of the smallest 1\% of the data values is analyzed
and the value for which the first derivate has the absolute maximum is
taken as the DN for a dark object.
}
\details{
The DN for a dark object is extracted from a histogram similar to
Chavez (1988).
}
\examples{
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC8*.tif"), full.names = TRUE)
sat <- satellite(files)

calcDODN(getSatDataLayer(sat, bcde = "B002n"))
}
\references{
Chavez Jr PS (1988) An improved dark-object subtraction technique
for atmospheric scattering correction of multispectral data. Remote Sensing
of Environment 24/3, doi:10.1016/0034-4257(88)90019-3, available online at
 \url{http://www.sciencedirect.com/science/article/pii/0034425788900193}
}
\seealso{
The DN is used by \code{\link{calcPathRadDOS}} for computing the
path radiance based on the dark object method.
}

