% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satdad_Rfunctions.R
\name{supportAnalysisEmp}
\alias{supportAnalysisEmp}
\title{Analysis of the empirical support of the tail dependence structure.}
\usage{
supportAnalysisEmp(sample, k,  names = NULL, nboot = 20)
}
\arguments{
\item{sample}{A \code{(n times d)} matrix.}

\item{k}{An integer smaller or equal to \code{n}.}

\item{names}{A character vector of length \code{d} which replaces \code{as.character(1:d)} (the default ones).}

\item{nboot}{An integer (20 by default) that indicates the number of \code{(n times d)} samples generated from the asymptotic independence.}
}
\value{
\itemize{
\item  \code{$message}  contains the conclusion of the analysis.
\item \code{$selected.subsets}  is a list of the selected subsets.
\item  \code{$comparable.emp.coeff}  contains the largest comparable tsic values in descending order if a selection is made, otherwise all ordered comparable tsic values are returned.
\item The boxplot displays all comparable tsic values, with the name of the largest selected subset displayed if a selection is made.
}
}
\description{
Diagnostics are used to analyze tail dependence support in a sample. Subsets are selected based on a comparable version of empirical tail superset importance coefficients (tsic), which are computed while considering their theoretical upper bounds.
}
\details{
The upper bound for tsic is determined by Theorem 2 in Mercadier and Ressel (2021).
To calculate the tsic for a subset of interest, let \eqn{I} be a subset of interest and \eqn{|I|} its cardinality.
The upper bound is given by \eqn{b(|I|):=\dfrac{2 (|I| !)^2}{(2|I|+2)!}}.
All the tsic values are computed and normalized for comparison, with the normalization factor being  \eqn{\dfrac{1}{b(|I|)}}.
These normalized values are then displayed using boxplots.
A reference level for tail independence is established by analyzing \code{nboot} pseudo-observations sampled from tail independence.
The subsets with the highest renormalized coefficients are identified as the tail dependence support.
}
\examples{

## Fix a 5-dimensional asymmetric tail dependence structure
ds5 <- vector("list")
ds5$d <- 5
ds5$type <- "alog"
ds5$sub <- list(c(1,3),2:4,c(2,5))
ds5$asy <- list(c(1,.3),c(.5,1-.3,1), c(1-.5,1))
ds5$dep <- c(.2,.5,.3)

## Simulate ArchimaxMevlog random vectors
sample.gamma <- rArchimaxMevlog(500, ds5, dist = "gamma", dist.param = c(.5, 1))

## Provide the diagnostics associated with k = 50
supportAnalysisEmp(sample.gamma, k = 50)

}
\seealso{
\code{\link[satdad]{tsicEmp}},   \code{\link[satdad]{graphsEmp}}, \code{\link[satdad]{plotClevEmp}},
}
\author{
Cécile Mercadier (\code{mercadier@math.univ-lyon1.fr})
}
