% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satdad_Rfunctions.R
\name{ec}
\alias{ec}
\title{Extremal coefficients for  Mevlog models.}
\usage{
ec(ds, ind = 2, norm = FALSE)
}
\arguments{
\item{ds}{An object of class \code{ds}.}

\item{ind}{A character string among "with.singletons" and "all" (without singletons), or an integer in \eqn{\{2,...,d\}} or a list of subsets from  \eqn{\{1,...,d\}}. The default is \code{ind = 2}, all pairwise coefficients are computed.}

\item{norm}{A boolean. `FALSE` (the default): ec is computed. `TRUE`:  inverse normalized ec is computed.}
}
\value{
The function returns a list of two elements:
\itemize{
\item{\code{subsets}} A list of subsets from  \eqn{\{1,...,d\}}.

When \code{ind} is given as an integer, \code{subsets} is the list of subsets from  \eqn{\{1,...,d\}} with cardinality \code{ind}. When \code{ind} is the list, it corresponds to \code{subsets}.

When \code{ind = "with.singletons"}  subsets is the list of all non empty subsets in \eqn{\{1,...,d\}}.

When \code{ind = "all"}   subsets is the list of all subsets in \eqn{\{1,...,d\}} with cardinality larger or equal to 2.


\item{\code{ec}} A vector of theoretical extremal coefficients associated with the list \code{subsets}.

An extremal coefficient associated with the subset \eqn{I} is \eqn{\ell(1_I,0_{I^c})}. Its value lies in \eqn{(1, |I|)}.

When \code{norm = TRUE}, then inverse normalized ec are computed by  \eqn{\dfrac{|I|-ec}{|I|-1}}.
}
}
\description{
Theoretical extremal coefficients for  Mevlog models. A \code{Mevlog} model is a multivariate extreme value (symmetric or asymmetric) logistic model.
}
\details{
The tail dependence structure is set by a \code{ds} object. It thus corresponds to the stable tail dependence function \eqn{\ell}. The way to deduce the stable tail dependence function \eqn{\ell} from \code{ds} is explained in the Details section of \code{\link[satdad]{gen.ds}}.
}
\examples{

## Fix a 4-dimensional asymmetric tail dependence structure
ds4 <-  gen.ds(d = 4)
## Compute all theoretical extremal coefficients
ec(ds = ds4, ind = "with.singletons")
## Compute theoretical extremal coefficients associated with the support of ds4
ec(ds = ds4, ind = ds4$sub)

## Fix a 6-dimensional asymmetric tail dependence structure
ds6 <- gen.ds(d = 6, sub = list(1:2,2:5,5:6))
## Compute all theoretical extremal coefficients on subsets with cardinality 5
ec(ds = ds6, ind = 5)
## Compute inverse renormalized ec
ec(ds = ds6, ind = list(1:2,1:4,1:6), norm = TRUE)

}
\references{
Mercadier, C. and Roustant, O. (2019)
The tail dependograph.
\emph{Extremes}, \bold{22}, 343--372.

Tiago de Oliveira, J. (1962/63)
Structure theory of bivariate extremes, extensions.
\emph{Estudos de Matematica, Estatistica, e Economicos}, 7:165--195.

Smith, R. L. (1990)
Max-stable processes and spatial extremes.
\emph{Dept. of Math., Univ. of Surrey}, Guildford GU2 5XH, England.
}
\seealso{
\code{\link[satdad]{ellMevlog}},  \code{\link[satdad]{gen.ds}}, \code{\link[satdad]{graphs}},  \code{\link[satdad]{tsic}}
}
\author{
Cécile Mercadier (\code{mercadier@math.univ-lyon1.fr})
}
