% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_qmd_file.R
\name{gen_qmd_file}
\alias{gen_qmd_file}
\title{Generate Quarto Index File That Merges All Chapters}
\usage{
gen_qmd_file(
  path = NULL,
  filename = "0_report",
  yaml_file = NULL,
  qmd_start_section_filepath = NULL,
  qmd_end_section_filepath = NULL,
  chapter_structure = NULL,
  title = NULL,
  authors = NULL,
  output_formats = NULL,
  output_filename = NULL,
  call = rlang::caller_env()
)
}
\arguments{
\item{path}{String, where to write qmd-file.}

\item{filename}{String, bare name of qmd-file. Default: "0_report". If NULL,
generates a sanitized version of the title. If both filename and title are NULL, errors.}

\item{yaml_file}{A string containing the filepath to a yaml-file to be inserted at top of qmd-file.}

\item{qmd_start_section_filepath, qmd_end_section_filepath}{String, filepath
to a qmd-file inserted at start and end of file.}

\item{chapter_structure}{\emph{What goes into each chapter and sub-chapter}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

Data frame (or tibble, possibly grouped). One row per chapter. Should
contain the columns 'chapter' and 'dep', Optionally 'indep' (independent
variables) and other informative columns as needed.}

\item{title}{\emph{Title of report}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Added automatically to YAML-header of index.qmd and report.qmd-files.}

\item{authors}{\emph{Authors of entire report}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

If NULL, infers from \code{chapter_structure[[authors_col]]}, and collates for entire report.
If multiple authors per chapter, separate with semicolon. Ensure consistency.}

\item{output_filename, output_formats}{Character. If applied, will construct
list of links to files with said \code{output_filename}.}

\item{call}{Internal call argument. Not to be fiddled with by the user.}
}
\value{
A string containing the filepath to the generated Quarto report file.
}
\description{
This function creates an index Quarto file (QMD) that merges all chapters in the specified order. It can also include optional title and author(s) information.
}
\keyword{internal}
