## Do not edit this file manually.
## It has been automatically generated from *.org sources.
library(sarima)
context("Fitting Sarima models with estimated unit roots")

## 2018-08-23 wrapping the tests in test_that() and adding an expectation
##            in the hope that this will speed up valgrind.
test_that("Sarima and Arma models work ok", {
    expect_true(TRUE) # for now

    ## the air plane model (1-B)(1-B^12) + MA(1) + SMA(12, 1)
    sarima(log(AirPassengers) ~ 0 | ma(1, c(-0.3)) + sma(12,1, c(-0.1)) +
               i(1) + si(12,1), ss.method = "sarima")

    ## two ways to estimate the parameters of the unit root operator
    ## to see if the result is similar (it is)

    ## 2025-03-18 wrap in try() to avoid CRAN 'Additional issues' on OpenBLAS:
    ##   Error in optim(flat_par[nonfixed], ss_sarima, use.symm = use.symm, method = "BFGS",  :
    ##      non-finite finite-difference value [1]
    ##    An object of class "SarimaModel"
    ##    [ FAIL 1 | WARN 10 | SKIP 0 | PASS 217 ]
    ##
    ##    ══ Failed tests ════════════════════════════════════════════════════════════════
    ##    ── Error ('test-sarima-uar.R:17:1'): Sarima and Arma models work ok ────────────
    ##    Error in `optim(flat_par[nonfixed], loglik_sarima, use.symm = use.symm,
    ##        method = "BFGS", hessian = TRUE)`: non-finite finite-difference value [1]
    ##    Backtrace:
    ##        ▆
    ##     1. └─sarima::sarima(...) at test-sarima-uar.R:17:1
    ##     2.   └─sarima:::sarimat(...)
    ##     3.     └─stats::optim(...)
    ##
    ##    [ FAIL 1 | WARN 10 | SKIP 0 | PASS 217 ]
    ##    Error: Test failures
    ##    Execution halted
    ##
    ## TODO: check the code to make it more robust (but this works on numerical limits)
    try(
    sarima(log(AirPassengers) ~ 0 | ma(1, c(-0.3)) + sma(12,1, c(-0.1)) +
               uar(13, c(rep(0,12), 1), fixed = 13, atanh.tr = TRUE), ss.method = "sarima")
    )

    sarima(log(AirPassengers) ~ 0 | ma(1, c(-0.3)) + sma(12,1, c(-0.1)) +
               i(2) + uar(11, c(rep(0,10), 1), fixed = 11), ss.method = "sarima")
})
