## Do not edit this file manually.
## It has been automatically generated from *.org sources.

makeUpdateFun_arma0 <- function(pind, qind, s2ind){
    pind
    qind
    s2ind

    ## todo: check the case when both p=0 and q=0?
    ## this is based on an example in package KFAS
    function(pars, model, estimate = TRUE){
        wrk <- try(SSMarima(artransform(pars[pind]), artransform(pars[qind]),
                            Q = exp(pars[s2ind])), silent = TRUE)

        if(inherits(wrk, "try-error")){
            if(estimate) 1e100  else model
        }else{
            model["T", "arima"]  <- wrk$T
            model["R", "arima"]  <- wrk$R
            model["P1", "arima"] <- wrk$P1
            model["Q", "arima"]  <- wrk$Q
            if(estimate){
                -logLik(model)
            }else
                model
        }
    }
}

makeArma0SSModel <- function(ar = numeric(0), ma = numeric(0), Q = 1, H = 0, y){
    ## todo: more care with the environment?
    arma0 <- SSModel(y ~ -1 + SSMarima(ar = ar, ma = ma, Q = 1), H = 0)
    p <- length(ar)
    q <- length(ma)

    pind <- seq_len(p)
    qind <- p + seq_len(q)
    s2ind <- p + q + 1
    ## todo: check the case when both p=0 and q=0?

    likfn0 <- makeUpdateFun_arma0(pind, qind, s2ind)

    list(model = arma0, updateFun = likfn0)
}

fitArma0Model <- function(arma0ss, init = NULL, method = "BFGS", hessian = TRUE, ...){
    e <- environment(arma0ss$updateFun)
    p <- length(e$pind)
    q <- length(e$qind)
    if(is.null(init)){
        init <- numeric(p + q + 1)
    }
    arma0_fit <- optim(par = init,
                       fn = arma0ss$updateFun,
                       method = method,
                       model = arma0ss$model,
                       hessian = hessian, ...)
    
    ## turn into SS model object
    modelObj <- arma0ss$updateFun(arma0_fit$par, arma0ss$model, FALSE)

    ar <- modelObj$T[seq_len(p)]
    ma <- modelObj$R[seq_len(q+1)[-1]] # 2:(q+1), safely
    sigma2 <- as.vector(modelObj$Q)

            # nn <- dim(arma0_fit$hessian)[1]
            # sqrt(diag(solve(arma0_fit$hessian)))
            # ## ignoring sigma2:
            # sqrt(diag(solve(arma0_fit$hessian[-nn, -nn])))

    fi <- solve(arma0_fit$hessian[-(p+q+1), -(p+q+1)])
    ## correct for phi = phi(parcor)
    Jphi <- pacf2ArWithJacobian(ar2Pacf(ar))$J
    Jtheta <- pacf2ArWithJacobian(ar2Pacf(ma), TRUE)$J
    J2 <- dbind(Jphi, Jtheta)

    ## correct for the tanh transform.
       # Jtanh <- diag(1/cosh(arma0_fit$par[seq_len(p+q)])^2)
            # fi <- J2 %*% Jtanh %*% fi %*% Jtanh  %*% t(J2)
       # J <- J2 %*% Jtanh             
    J <- J2 / rep(cosh(arma0_fit$par[seq_len(p+q)])^2, each = p + q)

    fi <- J %*% tcrossprod(fi, J) # equivalent to J %*% fi %*% t(J)
        # 
        # fi <- solve(arma0_fit$hessian)
        # J <- dbind(J2 %*% Jtanh, exp(arma0_fit$par[p+q+1]))
        # fi <- J %*% fi %*% t(J)
        # fi <- fi[-(p+q+1), -(p+q+1)]

    se <- sqrt(diag(fi))
    se.asy <- sqrt(diag(FitARMA::InformationMatrixARMA(ar, -ma)) /
                                                    attr(modelObj, "n", exact = TRUE))

    param <- c(ar, ma)

    nams <- c(paste0("ar",  seq_len(p)), paste0("ma",  seq_len(q)))
    names(se.asy) <- names(se) <- names(param) <- nams

    list(par = param, se = se, se.asy = se.asy,
         optim = arma0_fit, SSModel = modelObj, vcov = fi)
}

## This is unfinished!
##
fitSarimaModel <- function(model, y, data){
    if(!inherits(model, "formula"))
        stop("unsupported class ", class(model), " of argument 'model'")

    fo <- terms(model, specials = "SARIMA")

    if(is.null(attr(fo, "specials")$SARIMA))
        molist <- SARIMA(model)
    else
        stop("feature not implemented yet")


    arma <- molist[names(molist) %in% c("arma", "ar", "ma")]
    p <- sum(sapply(arma, function(x) if(is.null(x$p)) 0 else x$p))
    q <- sum(sapply(arma, function(x) if(is.null(x$q)) 0 else x$q))

    ## seasonal arma
    sarma <- molist[names(molist) %in% c("sarma", "sar", "sma")]
    pqs <- sapply(sarma, function(x) c(x$s, x$p, x$q))
    if(is.null(pqs)){
        pqs <- matrix(0, 0, 3)
    }else{
        pqs <- t(pqs)
        s.all <- pqs[ , 1]
        s.unique <- unique(s.all)
        pqs <- t(sapply(s.unique, 
                      function(s) c(s, sum(pqs[s.all == s, 2]), sum(pqs[s.all == s, 3]))))
    }

    ## integration order
    Id <- molist[names(molist) %in% c("i")]
    d <- sum(sapply(Id, function(x) x$d))  

    ## summation  op.
    s.op <- molist[names(molist) == "s"]
    opS <- lapply(s.op, function(x) x$m)
    if(is.null(opS))
        opS <- numeric(0)
    else 
        opS <- unlist(opS) # for now simply merge multiple appearances

    ## seas. integration  - a matrix with c(season, d) in each row
    ## TODO: add this to I(d) and 1+B+ ... +B^m ?
    SId <- molist[names(molist) %in% c("si")]
    D <- sapply(SId, function(x) c(x$s, x$d))
    if(is.null(D)){
        D <- 0
    }else{
        D <- t(D)
        s.all <- D[ , 1]
        s.unique <- unique(s.all)
        D <- t(sapply(s.unique, function(s) c(s, sum(D[s.all == s, 2]))))
    }

    ## seas. summation  - a list with c(season, m) in each row
    Smd <- molist[names(molist) %in% c("si")]
    ssum <- lapply(Smd, function(x) c(x$s, x$m))

    ## unit roots
    Uroots <- molist[names(molist) == "u"]
    rootU <- unlist(lapply(Uroots, function(x) x$u))
    if(!is.null(rootU)){
        ## complex 'x' is a root; real x is a fraction of 2pi
        ## store the coefficient of the first power of the quaratic (the other two are = 1)
        rootU <- sapply(rootU, function(x) if(is.complex(x)) -2*Re(x) else cospi(2*x))
    }

    ## seasonal unit roots
    SUroots <- molist[names(molist) == "su"]
    rootSU <- lapply(SUroots, function(x) list(s = s, u = u))
    if(!is.null(rootSU)){
        ## store the coefficient of the first power of the quaratic (the other two are = 1)
        ## TODO: check that the values of 'u' are 1, ..., s/2 or [s/2]
        wrk <- vector("list", length = length(rootSU))
        for(i in seq_along(rootSU)){
            su <- rootSU[[i]]
            s <- su$s
            u <- sapply(su$u, function(x) if(is.complex(x)) -2*Re(x) else cospi(2*x/s))
            rootSU[[i]]$u <- u
        } 
    }

    ## compute the total unit roots op.

    z <- polynom(0,1) 
    polyDelta <- do.call("polylist", list( 
                   (1-z)^d,
                   do.call(polylist, lapply(opS, function(x) rep(1, x))),
                   do.call(polylist, apply(D, 1, function(x) (1 - z^x[1])^x[2])),
                   do.call(polylist, lapply(rootU, function(x) c(1, x, 1)))
                   ))
    Delta <- coef(prod(polyDelta))

    environment()
}
