% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{read_sfn_metadata}
\alias{read_sfn_metadata}
\title{Read and combine all metadata}
\usage{
read_sfn_metadata(folder = ".", .write_cache = FALSE)
}
\arguments{
\item{folder}{Route to the folder containing the data. Default to working
directory}

\item{.write_cache}{Logical indicating if a cached copy of the metadata must
be written in \code{folder}.}
}
\value{
A list of tibbles with the five metadata classes (site, stand,
  species, plant and environmental)
}
\description{
Read metadata from all sites in folder and write it to disk to cache the
info for easy and fast access
}
\details{
Load all data in memory to collect metadata info can be resource limiting.
For easy and quick access to metadata, this function stores an .RData file
in the specified folder along the data with all the metadata preloaded. Also
it return it as an object to use in filtering and selecting sites.
}
\examples{
# Let's access the data in "folder". This typically is the folder where the
# sapflow data at the desired unit level is (i.e. "RData/plant"), but in this
# example we will create a temporal folder with some data to test the function
folder <- tempdir()
save(ARG_TRE, file = file.path(folder, 'ARG_TRE.RData'))
save(ARG_MAZ, file = file.path(folder, 'ARG_MAZ.RData'))

# create and load the metadata. The first time we use .write_cache = TRUE,
# to ensure creating a file containing the metadata for speed the process
# for the next times
read_sfn_metadata(
  folder = folder, .write_cache = TRUE
)
# a cached copy must have been written to "folder"
file.exists(paste0(folder, '.metadata_cache.RData')) # TRUE

# after that, we only need to especify the folder
sites_metadata <- read_sfn_metadata(folder = folder) # quicker than before
sites_metadata

}
