% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_SANBA_plotting.R
\name{plot.SANmcmc}
\alias{plot.SANmcmc}
\title{Visual Check of the Convergence of the MCMC Output}
\usage{
\method{plot}{SANmcmc}(
  x,
  param = c("mu", "sigma2", "pi", "num_clust", "alpha", "beta"),
  show_density = TRUE,
  add_burnin = 0,
  show_convergence = TRUE,
  trunc_plot = 2,
  ...
)
}
\arguments{
\item{x}{Object of class \code{SANmcmc} (usually, the result of a call to \code{fit_CAM}, \code{fit_fiSAN}, or \code{fit_fSAN}, used with the \code{est_method = "MCMC"} argument).}

\item{param}{String with the names of the parameters to check. It can be one of \code{"mu"}, \code{"sigma2"}, \code{"pi"},
\code{"num_clust"}, \code{"alpha"}, \code{"beta"}.}

\item{show_density}{Logical (default \code{TRUE}). Should a kernel estimate of the density be plotted?}

\item{add_burnin}{Integer (default = 0). Additional number of observations to discard in the burn-in.}

\item{show_convergence}{Logical (default \code{TRUE}). Should a superimposed red line of the cumulative mean be plotted?}

\item{trunc_plot}{Integer (default = 10). For multidimensional parameters, the maximum number of components to be plotted.}

\item{...}{Ignored.}
}
\value{
The function displays the traceplots and posterior density estimates of the parameters sampled in the MCMC algorithm.
}
\description{
Plot method for objects of class \code{SANmcmc}.
Check the convergence of the MCMC through visual inspection of the chains.
}
\note{
The function is not available for the observational weights \eqn{\omega}.
}
\examples{
set.seed(123)
y <- c(rnorm(40,0,0.3), rnorm(20,5,0.3))
g <- c(rep(1,30), rep(2, 30))
out <- fit_fiSAN(y = y, group = g, "MCMC", mcmc_param = list(nrep = 500, burn = 200))
plot(out, param = "mu", trunc_plot = 2)
plot(out, param = "sigma2", trunc_plot = 2)
plot(out, param = "alpha", trunc_plot = 1)
plot(out, param = "alpha", add_burnin = 100)
plot(out, param = "pi", trunc_plot = 4, show_density = FALSE)

out <- fit_CAM(y = y, group = g, "MCMC",
mcmc_param = list(nrep = 500, burn = 200, seed= 1234))
plot(out, param = "mu", trunc_plot = 2)
plot(out, param = "sigma2", trunc_plot = 2)
plot(out, param = "alpha")
plot(out, param = "pi", trunc_plot = 2)
plot(out, param = "pi", trunc_plot = 5)
plot(out, param = "num_clust", trunc_plot = 5)
plot(out, param = "beta", trunc_plot = 2)

out <- fit_fSAN(y = y, group = g, "MCMC", mcmc_param = list(nrep = 500, burn = 200))
plot(out, param = "mu", trunc_plot = 2)
plot(out, param = "sigma2", trunc_plot = 2)
plot(out, param = "pi", trunc_plot = 4,
     show_convergence = FALSE, show_density = FALSE)

}
