% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/b4ddm.R
\name{b4ddm}
\alias{b4ddm}
\title{Statistical power for a hyphotesis testing on a double difference of means.}
\usage{
b4ddm(N, n, mu1, mu2, mu3, mu4, sigma1, sigma2, sigma3, sigma4, D, DEFF = 1,
  conf = 0.95, T = 0, R = 1, plot = FALSE)
}
\arguments{
\item{N}{The population size.}

\item{n}{The sample size.}

\item{mu1}{The value of the estimated mean of the variable of interes for the first population.}

\item{mu2}{The value of the estimated mean of the variable of interes for the second population.}

\item{mu3}{The value of the estimated mean of the variable of interes for the third population.}

\item{mu4}{The value of the estimated mean of the variable of interes for the fourth population.}

\item{sigma1}{The value of the estimated variance of the variable of interes for the first population.}

\item{sigma2}{The value of the estimated mean of a variable of interes for the second population.}

\item{sigma3}{The value of the estimated variance of the variable of interes for the third population.}

\item{sigma4}{The value of the estimated mean of a variable of interes for the fourth population.}

\item{D}{The value of the null effect.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default \code{conf = 0.95}.}

\item{T}{The overlap between waves. By default \code{T = 0}.}

\item{R}{The correlation between waves. By default \code{R = 1}.}

\item{plot}{Optionally plot the errors (cve and margin of error) against the sample size.}
}
\value{
The power of the test.
}
\description{
This function computes the power for a (right tail) test of double difference of means
}
\details{
We note that the power is defined as: \deqn{1-\Phi(Z_{1-\alpha} - \frac{(D - [(\mu_1 - \mu_2) - (\mu_3 - \mu_4)])}{\sqrt{\frac{1}{n}(1-\frac{n}{N})S^2}})}
where \deqn{S^2 = DEFF (\sigma_1^2 + \sigma_2^2 + \sigma_3^2 + \sigma_4^2}
}
\examples{
b4ddm(N = 100000, n = 400, mu1=50, mu2=55, mu3=50, mu4=55,
sigma1 = 10, sigma2 = 12, sigma3 = 10, sigma4 = 12, D = 7)
b4ddm(N = 100000, n = 400, mu1=50, mu2=55, mu3=50, mu4=65,
sigma1 = 10, sigma2 = 12, sigma3 = 10, sigma4 = 12, D = 12, plot = TRUE)
b4ddm(N = 100000, n = 4000, mu1=50, mu2=55, mu3=50, mu4=65,
sigma1 = 10, sigma2 = 12, sigma3 = 10, sigma4 = 12, D = 11, DEFF = 2, conf = 0.99, plot = TRUE)
}
\author{
Hugo Andres Gutierrez Rojas <hugogutierrez at usantotomas.edu.co>
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ss4p}}
}

