% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.salso.confidence.R
\name{plot.salso.confidence}
\alias{plot.salso.confidence}
\title{Confidence and Exemplar Plotting}
\usage{
\method{plot}{salso.confidence}(
  x,
  estimate = NULL,
  data = NULL,
  showLabels = length(x$estimate) <= 50,
  ...
)
}
\arguments{
\item{x}{An object returned by the \code{\link{confidence}} function.}

\item{estimate}{A vector of length \code{n}, where \code{i} and \code{j} are
in the same subset (i.e., cluster) if and only if \code{estimate[i] ==
estimate[j]}.'  If \code{NULL}, the \code{x$estimate} in used.}

\item{data}{The data from which the distances were computed.}

\item{showLabels}{Should the names of items be shown in the plot?}

\item{...}{Currently ignored.}
}
\value{
\code{NULL}, invisibly.
}
\description{
This function produces confidence plots (e.g., heatmaps of pairwise
allocation probabilities) and exemplar plots. The "exemplar" refers to the
best representative of a particular cluster. See \code{\link{confidence}} for
further explanation.
}
\examples{
probs <- psm(iris.clusterings, parallel=FALSE)
est <- salso(probs, nPermutations=50, parallel=FALSE)$estimate
conf <- confidence(est, probs)
plot(conf)
plot(conf,data=iris)

}
\seealso{
\code{\link{confidence}}, \code{\link{psm}}, \code{\link{dlso}}, \code{\link{salso}}
}
\author{
David B. Dahl \email{dahl@stat.byu.edu}
}
