% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.cv.sail}
\alias{predict.cv.sail}
\alias{coef.cv.sail}
\title{Make predictions from a \code{cv.sail} object}
\usage{
\method{predict}{cv.sail}(object, newx, newe, s = c("lambda.1se",
  "lambda.min"), ...)

\method{coef}{cv.sail}(object, s = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{fitted \code{cv.sail} object}

\item{newx}{matrix of new values for \code{x} at which predictions are to be
made. Do not include the intercept (this function takes care of that). Must
be a matrix. This argument is not used for
\code{type=c("coefficients","nonzero")}. This matrix will be passed to
\code{\link{design_sail}} to create the design matrix necessary for
predictions. This matrix must have the same number of columns originally
supplied to the \code{sail} fitting function.}

\item{newe}{vector of new values for the exposure variable \code{e}. This is
passed to the \code{design_sail} function.}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which predictions
are required. Default is the value \code{s="lambda.1se"} stored on the CV
\code{object}. Alternatively \code{s="lambda.min"} can be used. If \code{s}
is numeric, it is taken as the value(s) of \code{lambda} to be used.}

\item{...}{other arguments passed to \code{\link{predict.sail}}}
}
\value{
The object returned depends the ... argument which is passed on to
  the predict method for \code{sail} objects.
}
\description{
This function makes predictions from a cross-validated sail
  model, using the stored "sail.fit" object, and the optimal value chosen for
  lambda.
}
\details{
This function makes it easier to use the results of cross-validation
  to make a prediction.
}
\examples{
data("sailsim")
f.basis <- function(i) splines::bs(i, degree = 3)
library(doParallel)
cl <- makeCluster(2)
registerDoParallel(cl)
cvfit <- cv.sail(x = sailsim$x, y = sailsim$y, e = sailsim$e,
                 parallel = TRUE, nlambda = 10,
                 maxit = 20, basis = f.basis,
                 nfolds = 3, dfmax = 5)
stopCluster(cl)
predict(cvfit) # predict at "lambda.1se"
predict(cvfit, s = "lambda.min") # predict at "lambda.min"
predict(cvfit, s = 0.5) # predict at specific value of lambda
predict(cvfit, type = "nonzero") # non-zero coefficients at lambda.1se

# predict response for new data set
newx <- sailsim$x * 1.10
newe <- sailsim$e * 2
predict(cvfit, newx = newx, newe = newe, s = "lambda.min")

}
\seealso{
\code{\link{predict.sail}}
}
