% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.sail.R
\name{cv.lspath}
\alias{cv.lspath}
\alias{cvcompute}
\alias{getmin}
\alias{lambda.interp}
\title{Compute cross validation error}
\usage{
cv.lspath(outlist, lambda, x, y, e, weights, foldid, type.measure, grouped,
  keep = FALSE)

cvcompute(mat, weights, foldid, nlams)

getmin(lambda, cvm, cvsd)

lambda.interp(lambda, s)
}
\arguments{
\item{outlist}{list of cross validated fitted models. List is of length equal
to \code{nfolds} argument in \code{\link{cv.sail}} function}

\item{lambda}{a user supplied lambda sequence. Typically, by leaving this
option unspecified users can have the program compute its own lambda
sequence based on \code{nlambda} and \code{lambda.factor}. Supplying a
value of lambda overrides this. It is better to supply a decreasing
sequence of lambda values than a single (small) value, if not, the program
will sort user-defined lambda sequence in decreasing order automatically.
Default: \code{NULL}.}

\item{x}{input matrix of dimension \code{n x p}, where \code{n} is the number
of subjects and p is number of X variables. Each row is an observation
vector. Can be a high-dimensional (n < p) matrix. Can be a user defined
design matrix of main effects only (without intercept) if
\code{expand=FALSE}}

\item{y}{response variable. For \code{family="gaussian"} should be a 1 column
matrix or numeric vector. For \code{family="binomial"}, should be a 1
column matrix or numeric vector with -1 for failure and 1 for success.}

\item{e}{exposure or environment vector. Must be a numeric vector. Factors
must be converted to numeric.}

\item{weights}{observation weights. Default is 1 for each observation.
Currently NOT IMPLEMENTED.}

\item{foldid}{numeric vector indicating which fold each observation belongs
to}

\item{type.measure}{loss to use for cross-validation. Currently only 3
options are implemented. The default is \code{type.measure="deviance"},
which uses squared-error for gaussian models (and is equivalent to
\code{type.measure="mse"}) there). \code{type.measure="mae"} (mean absolute
error) can also be used which measures the absolute deviation from the
fitted mean to the response (\eqn{|y-\hat{y}|}).}

\item{grouped}{This is an experimental argument, with default \code{TRUE},
and can be ignored by most users. This refers to computing \code{nfolds}
separate statistics, and then using their mean and estimated standard error
to describe the CV curve. If \code{grouped=FALSE}, an error matrix is built
up at the observation level from the predictions from the \code{nfold}
fits, and then summarized (does not apply to \code{type.measure="auc"}).
Default: TRUE.}

\item{keep}{If \code{keep=TRUE}, a \emph{prevalidated} array is returned
containing fitted values for each observation and each value of
\code{lambda}. This means these fits are computed with this observation and
the rest of its fold omitted. The \code{folid} vector is also returned.
Default: FALSE}

\item{mat}{matrix of predictions}

\item{nlams}{number of lambdas fit}

\item{cvm}{mean cv error}

\item{cvsd}{sd of cv error}

\item{s}{numeric value of lambda}
}
\description{
functions used to calculate cross validation error and used by
  the \code{\link{cv.sail}} function
}
\details{
The output of the \code{cv.lspath} function only returns values for
  those tuning parameters that converged. \code{cvcompute, getmin,
  lambda.interp} are taken verbatim from the \code{glmnet} package
}
\section{Functions}{
\itemize{
\item \code{cvcompute}: Computations for crossvalidation error

\item \code{getmin}: get lambda.min and lambda.1se

\item \code{lambda.interp}: Interpolation function.
}}

\references{
Jerome Friedman, Trevor Hastie, Robert Tibshirani (2010).
  Regularization Paths for Generalized Linear Models via Coordinate Descent.
  Journal of Statistical Software, 33(1), 1-22.
  \url{http://www.jstatsoft.org/v33/i01/}.
}
\seealso{
\code{\link{cv.sail}}
}
