% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-sim.R
\name{sim}
\alias{sim}
\title{Start simulation}
\usage{
sim(x, R = 1, path = NULL, overwrite = TRUE, ..., suffix = NULL,
  fileExt = ".csv", libs = NULL, exports = NULL)
}
\arguments{
\item{x}{a \code{sim_setup}}

\item{R}{number of repetitions.}

\item{path}{optional path in which the simulation results can be saved. They
will we coerced to a \code{data.frame} and then saved as 'csv'.}

\item{overwrite}{\code{TRUE}/\code{FALSE}. If \code{TRUE} files in
\code{path} are replaced. If \code{FALSE} files in \code{path} are not
replaced and simulation will not be recomputed.}

\item{...}{arguments passed to \code{\link{parallelStart}}.}

\item{suffix}{an optional suffix of file names.}

\item{fileExt}{the file extension. Default is ".csv" - alternative it can be
".RData".}

\item{libs}{arguments passed to \code{\link{parallelLibrary}}. Will be used
in a call to \code{\link{do.call}} after coersion with
\code{\link{as.list}}.}

\item{exports}{arguments passed to \code{\link{parallelExport}}. Will be used
in a call to \code{\link{do.call}} after coersion with
\code{\link{as.list}}.}
}
\value{
The return value is a list. The elements are the results of each
  simulation run, typically of class \code{data.frame}. In case you specified
  \code{path}, each element is \code{NULL}.
}
\description{
This function will start the simulation. Use the printing method as long as
you are testing the scenario.
}
\details{
The package parallelMap is utilized as back-end for parallel computations.

Use the argument \code{path} to store the simulation results in a directory.
This may be a good idea for long running simulations and for those using
large \code{data.frame}s. You can use \code{\link{sim_read_data}} to read
them in. The return value will change to NULL in each run.
}
\examples{
setup <- sim_base_lm()
resultList <- sim(setup, R = 1)

# For parallel computations you may need to export objects
localFun <- function() cat("Hello World!")
comp_fun <- function(dat) {
  localFun()
  dat
}

res <- sim_base_lm() \%>\% 
  sim_comp_pop(comp_fun) \%>\% 
  sim(R = 2, 
      mode = "socket", cpus = 2,
      exports = "localFun")

str(res)
}

