% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaoYuAr1.beta.R
\name{RaoYuAr1.beta}
\alias{RaoYuAr1.beta}
\title{Small Area Estimation using Hierarchical Bayesian for Rao-Yu Model under Beta Distribution}
\usage{
RaoYuAr1.beta(
  formula,
  area,
  period,
  iter.update = 3,
  iter.mcmc = 2000,
  thin = 1,
  burn.in = 1000,
  tau.e = 1,
  tau.v = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{area}{Number of areas (domain) of the data}

\item{period}{Number of periods (subdomains) for each area of the data}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{2000}}

\item{thin}{Thinning rate, must be a positive integer with default \code{1}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{1000}}

\item{tau.e}{Variance of area-by-time effect of variable interest with default \code{1}}

\item{tau.v}{Variance of random area effect of variable interest with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method}
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{alpha}{Parameter dispersion of Generalized Poisson distribution}
   \item{plot}{Trace, Density, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \code{ydi}
}
\examples{
##For data without any non-sampled area
data(dataBetaAr1)     # Load dataset
dataBetaAr1 = dataBetaAr1[1:25,]
formula = ydi ~ xdi1 + xdi2
area = max(dataBetaAr1[, "area"])
period = max(dataBetaAr1[,"period"])

result <- RaoYuAr1.beta(formula, area, period, data = dataBetaAr1)
result$Est
result$refVar
result$coefficient
result$plot
## For data with non-sampled area use dataBetaAr1Ns

}
